{object object=$active_quote user=$logged_user show_inspector=false}
	<div class="invoice">
	  <div class="invoice_content">
	    <div class="invoice_data">
	    	<ul class="properties">
	        <li class="property">
	          <span class="property_title"></span>
	          <span class="property_data invoice_name">{$active_quote->getName()}</span>
	        </li>
	        
	        <li class="property">
	          <span class="property_title">{lang}Currency{/lang}</span>
	          <span class="property_data">{$active_quote->getCurrencyCode()}</span>
	        </li>
	        
	        <li class="property">
	          <span class="property_title">{lang}Created On{/lang}</span>
	          <span class="property_data">{$active_quote->getCreatedOn()|date}</span>
	        </li>
	        
					{if $active_quote->getStatus() == $smarty.const.INVOICE_STATUS_SENT}
	        <li class="property">
	          <span class="property_title">{lang}Sent On{/lang}</span>
	          <span class="property_data">{$active_quote->getSentOn()|date}</span>
	        </li>
					{/if}
					
					{assign var=closed_on value=$active_quote->getClosedOn() instanceof DateValue}
	        <li class="property {if !$closed_on}hidden{/if}">
	          <span class="property_title">{lang}Closed On{/lang}</span>
	          <span class="property_data">{$active_quote->getClosedOn()|date}</span>
	        </li>
	        
	        <li class="property company_name">
	          <span class="property_title">{lang}Company{/lang}</span>
	          <span class="property_data">
	          	{if $active_quote->getCompany() instanceof Company}
                {company_link company=$active_quote->getCompany()}
              {else}
                <b>{$active_quote->getCompanyName()}</b>
              {/if}
	          </span>
	        </li>
	        
	        <li class="property company_address">
	          <span class="property_title"></span>
	          <span class="property_data">{$active_quote->getCompanyAddress()|clean|nl2br nofilter}</span>
	        </li>
	      </ul>
	    </div>
			
			<div class="invoice_paper_items">
		    {if is_foreachable($active_quote->getItems())}
		      <table cellspacing="0" >
			      <thead>
			        <tr>
			          <td class="description">{lang}Description{/lang}</td>
			          <td class="unit_cost">{lang}Unit Cost{/lang}</td>
			          <td class="quantity">{lang}Qty.{/lang}</td>
			          <td class="tax_rate">{lang}Tax{/lang}</td>
			          <td class="total">{lang}Total{/lang}</td>
			        </tr>
			      </thead>
			      <tbody>
			      {foreach from=$active_quote->getItems() item=quote_item}
			        <tr class="{cycle values='odd,even'}">
			          <td class="description">{$quote_item->getDescription()}</td>
			          <td class="unit_cost">{$quote_item->getUnitCost()|money}</td>
			          <td class="quantity">{$quote_item->getQuantity()|money}</td>
			          <td class="tax_rate">{$quote_item->getTaxRateName()}</td>
			          <td class="total">{$quote_item->getTotal()|money}</td>
			        </tr>
			      {/foreach}
			      </tbody>
			      <tfoot>
			        <tr>
			          <td colspan="4" class="label">{lang}Subtotal{/lang}</td>
			          <td class="value"><span class="property_wrapper property_quote_subtotal">{$active_quote->getTotal()|money}</span></td>
			        </tr>
			        <tr>
			          <td colspan="4" class="label">{lang}Tax{/lang}</td>
			          <td class="value"><span class="property_wrapper property_quote_tax">{$active_quote->getTax()|money}</span></td>
			        </tr>
			        <tr class="total">
			          <td colspan="4" class="label">{lang}Total{/lang}</td>
			          <td class="value total"><span class="property_wrapper property_quote_total">{$active_quote->getTaxedTotal()|money}</span></td>
			        </tr>
			      </tfoot>
			    </table>
		    {else}
		      <p class="empty_page"><span class="inner">{lang}This quote has no items{/lang}</span></p>
		    {/if}
	    </div>
			
			<div class="invoice_paper_notes" style="display: {if $active_quote->getNote()}block{else}none{/if}">
        <h3>{lang}Note{/lang}</h3>
        <p><span>{$active_quote->getNote()|clean|nl2br nofilter}</span></p>
      </div>
	  </div>
	  
	  <div class="invoice_bottom"></div>
	  <div class="invoice_bottom_shadow_left"></div><div class="invoice_bottom_shadow_right"></div>
  </div>
  
  {object_comments object=$active_quote user=$logged_user interface=AngieApplication::INTERFACE_PHONE id=quote_comments}
  {render_comment_form object=$active_quote id=quote_comments}
{/object}