<div id="calendar_event_form">
	{wrap field=calendar_event_name}
		{text_field name='calendar_event[name]' value=$calendar_event_data.name label='Name' required=true}
	{/wrap}

	{wrap field=calendar_event_parent_id}
		{select_calendar name='calendar_event[parent_id]' value=$calendar_event_data.parent_id label='Calendar' user=$logged_user required=true}
	{/wrap}

	{wrap field=all_day_event}

	{/wrap}

	{wrap field=calendar_event_starts_on class="calendar_event_starts_on"}
		<div class="col-left">
			{select_date name='calendar_event[starts_on]' value=$calendar_event_data.starts_on skip_days_off=false label='Starts' class='starts_on'}
		</div>
		<div class="col-right">
			{select_calendar_event_time name="calendar_event[starts_on_time]" value=$calendar_event_data.starts_on_time label='Time' class="calendar_event_starts_on_time" user=$logged_user}
		</div>
	{/wrap}

	{wrap field=calendar_event_ends_on class="calendar_event_ends_on"}
		{select_date name='calendar_event[ends_on]' value=$calendar_event_data.ends_on skip_days_off=false label='Ends' class='ends_on'}
	{/wrap}

	{wrap field=calendar_event_repeat_event class="calendar_event_repeat"}
		{select_repeat_option name='calendar_event' value=$calendar_event_data.repeat_event label='Repeat' class="repeat_event" user=$logged_user repeat_event_option=$calendar_event_data.repeat_event_option repeat_until=$calendar_event_data.repeat_until starts_on=$calendar_event_data.starts_on}
	{/wrap}
</div>

<script type="text/javascript">
	$('div#calendar_event_form').each(function() {
		var wrapper = $(this);

		var checkbox = wrapper.find('input.all_day_event');
		var select_time = wrapper.find('select.calendar_event_starts_on_time');
		var starts_on = wrapper.find('input.starts_on');
		var ends_on = wrapper.find('input.ends_on');

		if (checkbox.is(':checked')) {
			select_time.hide();
		} // if

		wrapper.on('change', 'select.repeat_event', function() {
			var repeat_until = $(this).val();
			if (repeat_until != "{CalendarEvent::DONT_REPEAT}") {
				wrapper.find('ul.repeat_until').show();
			} else {
				wrapper.find('ul.repeat_until').hide();
			} // if

			var text = App.lang('days');
			if (repeat_until == "{CalendarEvent::REPEAT_YEARLY}") {
				text = App.lang('years');
			} else if (repeat_until == "{CalendarEvent::REPEAT_MONTHLY}") {
				text = App.lang('months');
			} else if (repeat_until == "{CalendarEvent::REPEAT_WEEKLY}") {
				text = App.lang('weeks');
			} // if

			wrapper.find('span.repeat_until_period_text').text(text);
		});

//		wrapper.on('click', 'div.calendar_event_starts_on_time input', function() {
//			if ($(this).is(":checked")) {
//				wrapper.find('.select_time').removeClass('hidden');
//			} else {
//				wrapper.find('.select_time').addClass('hidden');
//			} // if
//		});

		wrapper.on('change', 'input.starts_on, input.ends_on', function() {
			var date_picker = $(this);
			var starts_on_date = new Date(starts_on.val());
			var ends_on_date = new Date(ends_on.val());

			// set ends_on date
			if (starts_on_date > ends_on_date) {
				if (date_picker.is('.starts_on')) {
					ends_on.val(starts_on.val());
				} else {
					starts_on.val(ends_on.val());
				} // if
			} // if

			// different dates
			if (starts_on_date != ends_on_date) {
				select_time.hide();
				checkbox.prop('checked', true);
			} // if
		});

		wrapper.on('click', 'input.all_day_event', function(event) {
			var checkbox = $(this);

			if (checkbox.is(':checked')) {
				select_time.hide();
			} else {
				ends_on.val(starts_on.val());
				select_time.show();
			} // if
		});
	});
</script>