var SUBPATH = 49;
var csavet = null;
var guesta = null;

/*
** COMBOBOX
*/

(function( $ ) {
	$.widget( "ui.combobox", {
		_create: function() {
			var self = this,
				select = this.element.hide(),
				selected = select.children( ":selected" ),
				value = selected.val() ? selected.text() : "";
			var input = this.input = $( "<input>" )
				.insertAfter( select )
				.val( value )
				.autocomplete({
					delay: 0,
					minLength: 0,
					source: function( request, response ) {
						var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
						response( select.children( "option" ).map(function() {
							var text = $( this ).text();
							if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text.replace(
										new RegExp(
											"(?![^&;]+;)(?!<[^<>]*)(" +
											$.ui.autocomplete.escapeRegex(request.term) +
											")(?![^<>]*>)(?![^&;]+;)", "gi"
										), "<strong>$1</strong>" ),
									value: text,
									option: this
								};
						}) );
					},
					select: function( event, ui ) {
						ui.item.option.selected = true;
						self._trigger( "selected", event, {
							item: ui.item.option
						});
					},
					change: function( event, ui ) {
						if ( !ui.item ) {
							var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( $(this).val() ) + "$", "i" ),
								valid = false;
							select.children( "option" ).each(function() {
								if ( $( this ).text().match( matcher ) ) {
									this.selected = valid = true;
									return false;
								}
							});
							if ( !valid ) {
								$( this ).val( "" );
								select.val( "" );
								input.data( "autocomplete" ).term = "";
								return false;
							}
						}
					}
				})
				.addClass( "ui-widget ui-widget-content ui-corner-left" );

			input.data( "autocomplete" )._renderItem = function( ul, item ) {
				return $( "<li></li>" )
					.data( "item.autocomplete", item )
					.append( "<a>" + item.label + "</a>" )
					.appendTo( ul );
			};

			this.button = $( "<button type='button'>&nbsp;</button>" )
				.attr( "tabIndex", -1 )
				.attr( "title", "Show All Items" )
				.insertAfter( input )
				.button({
					icons: {
						primary: "ui-icon-triangle-1-s"
					},
					text: false
				})
				.removeClass( "ui-corner-all" )
				.addClass( "ui-corner-right ui-button-icon" )
				.click(function() {
					if ( input.autocomplete( "widget" ).is( ":visible" ) ) {
						input.autocomplete( "close" );
						return;
					}
					$( this ).blur();
					input.autocomplete( "search", "" );
					input.focus();
				});
		},

		destroy: function() {
			this.input.remove();
			this.button.remove();
			this.element.show();
			$.Widget.prototype.destroy.call( this );
		}
	});
})( jQuery );


$(document).ready(function()
{
	/*
	**	RECHERCHE
	*/
	
	var searchBox	= $("#isearch");	
	var searchBoxD	= 'Rechercher ...';
	searchBox.focus(function()
	{
		$(this).removeClass("isactive");
		if($(this).attr("value") == searchBoxD)
			$(this).attr("value", "");
	});
	searchBox.blur(function()
	{
		if($(this).attr("value") == "")
		{
			$(this).addClass("isactive");
			$(this).attr("value", searchBoxD);
		}
	});
	
	/*
	**	TABLEAUX
	*/
	
	var tab_counter = 0;
	var tab_content = '';
	var tab_title = '';

	var $tabs = $("#tabs").tabs(
	{
		tabTemplate: "<li><a href='#{href}'>#{label}</a> <span class='ui-icon ui-icon-close'>Fermer</span></li>",
		add: function( event, ui )
		{
			var model	= '<table cellpadding="0" cellspacing="0" border="0" class="display manglemagic" id="table-' + tab_counter + '">'
						+ '<thead name="' + tab_content + '" id="thead-' + tab_counter + '">'
						+ '	<tr>'
						+ '		<th class="ui-corner-tl">Nom</th>'
						+ '		<th>Prénom</th>'
						+ '		<th>Numéro</th>'
						+ '		<th class="ui-corner-tr">Service</th>'
						+ '	</tr>'
						+ ' </thead>'
						+ ' <tfoot id="tfoot-' + tab_counter + '">'
						+ '	<tr>'
						+ '		<th class="ui-corner-bl">Nom</th>'
						+ '		<th>Prénom</th>'
						+ '		<th>Numéro</th>'
						+ '		<th class="ui-corner-br">Service</th>'
						+ '	</tr>'
						+ '</tfoot>'
						+ '</table>';
						
			$(ui.panel).append(model);
			
			var ret = $('.ui-tabs-nav').outerHeight()
					+ parseInt($('.ui-tabs-nav').css("margin-bottom"), 10)
					+ (2 * parseInt($('#tabs').css("padding-bottom"), 10))
					+ $('#zheadl').outerHeight()
					+ SUBPATH;
			
			$('#table-' + tab_counter).dataTable(
			{
				"bInfo": false,
				"bJQueryUI": true,
				"bPaginate": false,
				"bLengthChange": false,
				"bAutoWidth": false,
				"bRetrieve": true,
				"fTableID": tab_counter,
				"fTableCT": tab_content,
				"sDom": 't',
				"sScrollY": ret,
				"sAjaxSource": './select.php?patt=' + tab_content,
				"fnDrawCallback": function (oSettings)
				{
					if (oSettings.aiDisplay.length == 0)
					{
						return;
					}
					
					var nTrs = $('#table-' + oSettings.oInit.fTableID + ' tbody tr');
					
					if (nTrs[0] == undefined || nTrs[0] == null)
						return;
					var iColspan = nTrs[0].getElementsByTagName('td').length;
					var sLastGroup = "";
					for (var i = 0; i < nTrs.length; i++ )
					{
						var iDisplayIndex = oSettings._iDisplayStart + i;
						var sGroup = null;
						if (oSettings.aaSorting[0][0] == 0 || oSettings.aaSorting[0][0] == 1)
							sGroup = oSettings.aoData[oSettings.aiDisplay[iDisplayIndex]]._aData[oSettings.aaSorting[0][0]].substr(0, 1);
						else if (oSettings.aaSorting[0][0] == 2)
							sGroup = oSettings.aoData[oSettings.aiDisplay[iDisplayIndex]]._aData[oSettings.aaSorting[0][0]].substr(0, 2);
						else
							sGroup = oSettings.aoData[oSettings.aiDisplay[iDisplayIndex]]._aData[oSettings.aaSorting[0][0]];
						if (sGroup != sLastGroup)
						{
							var nGroup = document.createElement('tr');
							var nCell = document.createElement('td');
							nCell.colSpan = iColspan;
							nCell.className = "group";
							nCell.innerHTML = sGroup;
							nGroup.appendChild(nCell);
							nTrs[i].parentNode.insertBefore(nGroup, nTrs[i]);
							sLastGroup = sGroup;
						}
					}
				},
				"aoColumnDefs": [
					{"aTargets": [0], "sWidth": "30%", "sClass": "minicap"},
					{"aTargets": [1], "sWidth": "30%"},
					{"aTargets": [2], "sWidth": "20%"},
					{"aTargets": [3], "sWidth": "20%"}
				]
			});
			
			$.ajax({ url: "./action.php?add=" + tab_content });
			
			fixScrollSize(ui);
			fnFilterGlobal();
		},
		show: function(event, ui)
		{
			fixScrollSize(ui);
		},
		remove: function(event, ui)
		{
			id = $(ui).dataTableSettings[ui.panel.id.substr(5) - 1].oInit.fTableCT;
			$.ajax({ url: "./action.php?del=" + id });
		}
	});
	
	/*
	**  BOITE DE DIALOGUE
	*/
	
	var $dialog = $( "#dialog" ).dialog(
	{
		height: 297,
		resizable: false,
		autoOpen: false,
		modal: true,
		buttons:
		{
			"OK": function()
			{
				ftype = $('#dialog .ui-accordion-header.ui-state-active')[0];
				if (ftype.id == "select")
					addTab();
				else if (ftype.id == "create")
					alert('Nouveau calendrier ... pas encore créé ! ^^ ' + guesta.length);
				$(this).dialog( "close" );
			},
			"Annuler": function()
			{
				$(this).dialog( "close" );
			}
		},
		close: function()
		{
			$form[0].reset();
		}
	});

	var $form = $("form", $dialog).submit(function()
	{
		addTab();
		$dialog.dialog( "close" );
		return false;
	});

	function addTab()
	{
		if (arguments.length == 2)
		{
			tab_content = arguments[0];
			tab_title = arguments[1];
		}
		else
		{
			tab_content = $('#zsel').val();
			tab_title = $('#' + $('#zsel').val()).attr('name');
		}
		tab_counter++;
		$tabs.tabs( "add", "#tabs-" + tab_counter, tab_title );
	}

	$( "#add_tab" ).button().click(function()
	{
		$dialog.dialog( "open" );
	});

	$( "#tabs span.ui-icon-close" ).live( "click", function()
	{
		var index = $( "li", $tabs ).index( $( this ).parent() );
		$tabs.tabs( "remove", index );
	});
	
	eval(openInit);
	
	/*
	** ACCORDEON
	*/
	
	$( "#accordion" ).accordion();
	
	/*
	** COMBOBOX
	*/

	$( "#zsel" ).combobox();
	
	/*
	** TABLEAUX
	*/
	
	function fnStripAccent(str)
	{
		var rExps=[
		{re:/[\xC0-\xC6]/g, ch:'A'},
		{re:/[\xE0-\xE6]/g, ch:'a'},
		{re:/[\xC8-\xCB]/g, ch:'E'},
		{re:/[\xE8-\xEB]/g, ch:'e'},
		{re:/[\xCC-\xCF]/g, ch:'I'},
		{re:/[\xEC-\xEF]/g, ch:'i'},
		{re:/[\xD2-\xD6]/g, ch:'O'},
		{re:/[\xF2-\xF6]/g, ch:'o'},
		{re:/[\xD9-\xDC]/g, ch:'U'},
		{re:/[\xF9-\xFC]/g, ch:'u'},
		{re:/[\xD1]/g, ch:'N'},
		{re:/[\xF1]/g, ch:'n'} ];
		
		for(var i=0, len=rExps.length; i<len; i++)
			str=str.replace(rExps[i].re, rExps[i].ch);

		return (str);
	}
	
	function fnFilterGlobal ()
	{
		if ($("#isearch").attr("value") == searchBoxD)
			return;
		var lst = $('.manglemagic');
		for (var i = 0; i < lst.length; i += 3)
		{
			$('#' + lst[i + 1].id).dataTable().fnFilter( 
				fnStripAccent($("#isearch").val()),
				null, 
				false, 
				false
			);
		}
	}
	
	function fixScrollSize(ui)
	{
		$('.dataTables_scrollBody').each(function(index)
		{
			var ret = $('.ui-tabs-nav').outerHeight()
					+ parseInt($('.ui-tabs-nav').css("margin-bottom"), 10)
					+ (2 * parseInt($('#tabs').css("padding-bottom"), 10))
					+ $('#zheadl').outerHeight()
					+ SUBPATH;
			$(this).height($(window).height() - ret);
		});
		if (ui != null)
			csavet = $('div.dataTables_scrollBody>table.display', ui.panel).dataTable();
		if (csavet == null)
			return ;
		if ( csavet.length > 0 )
		{
			csavet.fnAdjustColumnSizing();
		}
	}
	
	$('#isearch').keyup( fnFilterGlobal );
	// $('body [name!="isearch"]').each(function (index, domEle) { $(this).disableTextSelect(); });
	
	$(window).bind('resize', function (event, ui)
	{
		fixScrollSize(ui);
	});
	
	$(document).bind('contextmenu', function()
	{
		return (false);
    });
	
	fixScrollSize();
	
	/*
	** ACTUALISATION
	*/
	
	$( "#refreshloc" ).button().click(function()
	{
		history.go(0);
	});
	
	/*
	** SELECTION MULTIPLE EMAIL
	*/

	function split( val )
	{
		return val.split( /,\s*/ );
	}
	
	function extractLast( term )
	{
		return split( term ).pop();
	}
	
	$( "#dir_guest" ).bind( "keydown", function( event ) {
		if ( event.keyCode === $.ui.keyCode.TAB &&
				$( this ).data( "autocomplete" ).menu.active ) {
			event.preventDefault();
		}
	})
	.autocomplete({
		minLength: 1,
		create: function(event, ui) {
			guesta = new Array();
		},
		source: function( request, response ) {
			$.getJSON( "./users.php", {
				patt: extractLast( request.term )
			}, response);
		},
		focus: function() {
			return false;
		},
		select: function( event, ui ) {
			var terms = split( this.value );
			guesta.push(ui.item.id);
			terms.pop();
			terms.push( ui.item.label );
			terms.push( "" );
			this.value = terms.join( ", " );
			return false;
		}
	});
});
