<?php

	/*
	** Classe de gestion LDAP
	*/
		
	class FLDAP
	{
		private		$ldap_serv;		// Adresse du serveur
		private		$ldap_port;		// Port de connexion au serveur
		private		$ldap_conn;		// Handle de ressource de connexion
		private		$ldap_base;		// 'Distinguished Name' de base
		private		$ldap_ufil;		// Filtre de recherche d'utilisateur
		private		$ldap_elem;		// Élements extraits de l'annuaire
		private		$ldap_user;		// Utilisateur LDAP
		private		$ldap_pass;		// Mot de passe LDAP
		
		/*
		** Constructeur et destructeur de classe
		*/
		
		public function		__construct()
		{
			$this->ldap_port = 0;
			$this->ldap_user = '';
			$this->ldap_pass = '';
			$this->ldap_base = '';
			$this->ldap_ufil = '';
			$this->ldap_serv = array();
			$this->ldap_conn = array();
			$this->ldap_elem = array();
		}
		
		public function		__destruct()
		{
			$this->close();
		}
		
		/*
		** Methode pour la connexion
		*/
		
		public function		connect()
		{
			/*
			** Tentative de connexion
			** L'utilisation de OpenLDAP 2.x.x ne permet pas le jet d'exception en cas d'erreur
			*/
			
			foreach ($this->ldap_serv as $serv => $port)
			{
				$msg = null;
				if (!($this->ldap_conn[$serv] = @ldap_connect($serv, $port)))
					$msg .= "<br/>$serv";
				ldap_set_option($this->ldap_conn[$serv], LDAP_OPT_PROTOCOL_VERSION, 3);
				ldap_set_option($this->ldap_conn[$serv], LDAP_OPT_REFERRALS, 0);
				if (isset($msg))
					throw new ExceptFLDAP(ExceptFLDAP::MSG_NOCONN . $msg);
			}
		}
		
		/*
		** Methode pour lier l'annuaire
		*/
		
		public function		bind()
		{
			foreach ($this->ldap_conn as $serv => $conn)
			{
				$msg = null;
				if (!(@ldap_bind($conn, $this->ldap_user, $this->ldap_pass)))
					$msg .= "<br/>$serv";
				if (!empty($msg))
					throw new ExceptFLDAP(ExceptFLDAP::MSG_NOBIND . $msg);
			}
		}
		
		/*
		** Methode pour l'authentification d'utilisateurs
		*/
		
		public function		authenticate($user, $pass)
		{
			$msg = null;
			$utab = $this->getUsers($user);
			foreach ($utab as $serv => $mtab)
			{
				foreach ($mtab as $msk => $tab)
				{
					if ($user != strtolower(utf8_encode($tab['samaccountname'][0])))
						continue;
					if (@ldap_bind($this->ldap_conn[$serv], utf8_encode($tab['dn']), $pass))
						return (true);
					else
					{
						/*
						** Sortie verbeuse du LDAP
						*/
						
						$idx['525'] = 'Utilisateur inexistant';
						$idx['52e'] = 'Informations d\'authentification invalides';
						$idx['530'] = 'Plage horaire de connexion non permise';
						$idx['531'] = 'Terminal de connexion non permis';
						$idx['532'] = 'Mot de passe expiré';
						$idx['533'] = 'Compte utilisateur désactivé';
						$idx['701'] = 'Compte utilisateur expiré';
						$idx['773'] = 'Réinitialisation de mot de passe obligatoire';
						$idx['775'] = 'Compte utilisateur bloqué';
						
						ldap_get_option($this->ldap_conn[$serv], 0x0032, $err);
						$err  = substr(strstr($err, 'data '), 5, 3);
						if (!empty($idx[$err]))
							$msg .= ('<br/>' . $idx[$err] . " ($serv)");
					}
				}
			}
			if (!empty($msg))
				throw new ExceptFLDAP(ExceptFLDAP::MSG_NOAUTH . $msg);
			return (false);
		}
		
		/*
		** Methode pour le cloture de connexion
		*/
		
		public function		close()
		{
			foreach ($this->ldap_conn as $conn)
				ldap_close($conn);
		}
		
		/*
		** Methode pour l'initialisation des variables
		*/
		
		public function		setUser($user)
		{
			$this->ldap_user = $user;
		}
		
		public function		setPass($pass)
		{
			$this->ldap_pass = $pass;
		}
		
		public function		addBase($base)
		{
			$this->ldap_base = array_merge((array)$this->ldap_base, (array)$base);
		}
		
		public function		setElem($elem)
		{
			$this->ldap_elem = array_merge((array)$this->ldap_elem, (array)$elem);
		}
		
		public function		addServ($serv, $port = 389)
		{
			$this->ldap_serv[$serv] = $port;
		}
		
		/*
		** Methode la recherche d'utilisateurs
		*/
		
		public function		getUsers($user)
		{
			$res = array();
			$this->bind();
			$this->ldap_ufil = '(&(objectClass=user)(objectCategory=person)(samaccountname=' . $user . '))';
			foreach ($this->ldap_conn as $serv => $conn)
			{
				foreach ($this->ldap_base as $base)
				{
					if (!($ins = @ldap_search($conn, $base, $this->ldap_ufil, $this->ldap_elem)))
						continue;
					$tmp = @ldap_get_entries($conn, $ins);
					if (empty($tmp) || $tmp['count'] == 0)
						continue;
					$res[$serv] = $tmp;
				}
			}
			return ($res);
		}
	}

	/*
	** Classe d'exception pour FLDAP
	*/
	
	class ExceptFLDAP extends Exception
	{
		const MSG_NOCONN	= "Impossible de se connecter au(x) serveur(s) LDAP : ";
		const MSG_NOBIND	= "Impossible de se lier au(x) serveur(s) LDAP : ";
		const MSG_NOAUTH	= "Impossible de connecter l'utilisateur : ";
		
		public function		__construct($message, $code = 0, Exception $previous = null)
		{
			parent::__construct($message, $code);
		}
	}
?>