<?php
	include_once('./lib/miscellaneous/ftp.misc.php');
		
	class FConnectorMDBCap extends FConnector
	{
		var $handle;
		var $ret;
		
		function			FConnectorMDBCap($data)
		{
			parent::FConnector($data);
		}
		
		public function		init()
		{
			$ftp = new FGetFromFTP($this->server);
			$ftp->connect($this->user, $this->pass);
			$ftp->get($this->fpath, $this->tpath);
			$ftp->close();
			
			$this->handle = new PDO('odbc:Driver={Microsoft Access Driver (*.mdb)};Dbq=' . $this->tpath . ';Uid=root');
			$this->ret = array();
		}
		
		public function		process()
		{
			$req = "SELECT * FROM IntRecords ORDER BY FicheId";
			$res = $this->handle->query($req);
			$res->setFetchMode(PDO::FETCH_OBJ);
			
			while ($rec = $res->fetch())
			{
				$rlname = mb_convert_case(utf8_encode($rec->Col2), MB_CASE_TITLE, "UTF-8");
				$rfname = mb_convert_case(utf8_encode($rec->Col3), MB_CASE_TITLE, "UTF-8");
				$rnumero = mb_convert_case(utf8_encode($rec->Col4), MB_CASE_TITLE, "UTF-8");
				$rservice = mb_convert_case(utf8_encode($rec->Col15), MB_CASE_TITLE, "UTF-8");
				
				$ent = array();
				array_push($ent, '1');
				array_push($ent, htmlspecialchars($rlname, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rfname, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rnumero, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rservice, ENT_NOQUOTES, "UTF-8"));
				array_push($this->ret, $ent);
			}
			
			$res->closeCursor();
			
			$req = "SELECT * FROM ExtRecords ORDER BY FicheId";
			$res = $this->handle->query($req);
			$res->setFetchMode(PDO::FETCH_OBJ);
			
			while ($rec = $res->fetch())
			{
				$rlname = mb_convert_case(utf8_encode($rec->Col2), MB_CASE_TITLE, "UTF-8");
				$rfname = mb_convert_case(utf8_encode($rec->Col3), MB_CASE_TITLE, "UTF-8");
				$rnumero = mb_convert_case(utf8_encode($rec->Col4), MB_CASE_TITLE, "UTF-8");
				$rservice = mb_convert_case(utf8_encode($rec->Col15), MB_CASE_TITLE, "UTF-8");
				
				$ent = array();
				array_push($ent, '3');
				array_push($ent, htmlspecialchars($rlname, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rfname, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rnumero, ENT_NOQUOTES, "UTF-8"));
				array_push($ent, htmlspecialchars($rservice, ENT_NOQUOTES, "UTF-8"));
				array_push($this->ret, $ent);
			}
			
			$res->closeCursor();
		}
		
		public function		retrieve()
		{
			return ($this->ret);
		}
		
		public function		finish()
		{
			$this->handle = null;
		}
	}
?>