<?php
	include('./update.php');

	class FBase
	{
		var $filename;
		
		public function		FBase($path)
		{
			if (filemtime($path) < (time() - EXPIRATION_TIME * 3600))
				update();
			$this->filename = $path;
		}
		
		public function		getPeople()
		{
			$data = implode('', file($this->filename));
			$parser = xml_parser_create();
			xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
			xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
			xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, 'UTF-8');
			xml_parse_into_struct($parser, $data, $values, $tags);
			xml_parser_free($parser);
			
			$peo = array();
		
			foreach ($tags as $key => $val)
			{
				if ($key == 'entity')
				{
					for ($i = 0; $i < count($val); $i += 2)
					{
						$offset = $val[$i] + 1;
						$len = $val[$i + 1] - $offset;
						$peo[] = $this->build(array_slice($values, $offset, $len));
					}
				}
				else
					continue;
			}
			return ($peo);
		}

		private function	build($tab)
		{
			for ($i = 0; $i < count($tab); $i++)
			{
				if (empty($tab[$i]["tag"]))
					continue;
				if (empty($tab[$i]["value"]))
					$mol[$tab[$i]["tag"]] = '';
				else
					$mol[$tab[$i]["tag"]] = $tab[$i]["value"];
			}
			
			return ($mol);
		}
	}
?>