/*
** DELIB'APP v1.0
** Florian Guitton
**
** Extention maison de jQuery pour la gestion de l'upload de fichiers
** Voir documentation (http://docs.jquery.com/Plugins/Authoring)
*/

var ful_identifier = 0;
var ful_normarrays = new Array();

(function ($) {
	$.fn.fileupload = function(params) {
		
		// Fusion des paramtres envoys et par dfaut
		params = $.extend({
			action: './upload',
			gauge: './gauge',
			format : 'json',
			delay: 1000,
			allowedpass: 5,
			prodlist: '#toclone',
			formcontainer: '#container',
			lister : '#filelist',
			progress : '#progressbar',
			deletion: function() {},
			init: function() {},
			start: function() {},
			success: function() {},
			failed: function() {}
		}, params);
		
		params.init(params);
		$(params.progress).progressbar();
	
		this.each(function(){
			$(this).fileinput({
				selected : function (event, opt){
					// A la slection du fichier
					
					var obj = ful_normarrays[ful_identifier] = {
						curr : 0,
						tots : 0
					};
					
					// Gnration de l'identifiant unique
					var file = opt.fileinput.fileFile;
					var filename = file.val();
					obj.idnt = sha1(uniqid(+new Date, true));
					obj.idps = ful_identifier++;
					
					// Contrle de l'extention : aucun contrle de magique number
					if (filename.substr(filename.lastIndexOf(".") + 1) != 'pdf')
						return boxinfo(APP_RESTFORMAT);
					
					obj.params = params;
					obj.params.start();
					
					// Cration du formulaire pour le fichier
					var newf = $('<form method="post" enctype="multipart/form-data"></form>');
					var curf = file.closest('form');
					var	inps = $('input', curf);
					var	dupl = inps.clone().appendTo(curf);
					inps.appendTo(newf).unbind();
					newf.appendTo(obj.params.formcontainer);
					
					// Chagement de cible pour le contrle 'fileinput'
					opt.fileinput.reorient($('#' + file.attr('id'), curf));
					
					obj.dest = $(obj.params.prodlist)
						.clone()
						.attr('id', 'divfup-' + obj.idnt)
						.removeClass('notdisp')
						.addClass((obj.idps % 2) ? 'filelistodd' : 'filelisteven');
										
					$('input[id=fupname]', obj.dest).attr({
						id : 'cpffup' + obj.idnt,
						value : filename.substr(filename.lastIndexOf('\\') + 1)
					});
					
					$('span[class~=imgs]', obj.dest).addClass('fileloader');
					$('span[class~=info]', obj.dest).text('0 %');
					
					$('button[id=del]', obj.dest).click(function(){
						obj.params.deletion(obj.dest);
					});
					
					// Ajout du formulaire compos  la page
					$(obj.params.lister).append(obj.dest);
					
					// Dfinition de l'vnement de soumission
					$(newf).submit(function (){
					
						// L'vitement d'action par dfaut n'est pas utilis pour permettre justement l'envoi du fichier
						// selon la procdure normale
						
						if (obj.active) 
							return (false);
						obj.active = true;
						
						// Pour permettre d'autre action utilisateur, le formulaire est plac dans une IFRAME au sein de la page
						var frame = $('<iframe id="' + obj.idnt + '" name="' + obj.idnt + '"></iframe>');
						$(this).attr('action', obj.params.action);
						$(this).attr('target', obj.idnt);
						$(this).prepend($('<input type="hidden"></input>').attr({
							'id' : 'UPLOAD_IDENTIFIER',
							'name' : 'UPLOAD_IDENTIFIER',
							'value' : obj.idnt
						}));
						
						frame.css({
							position : 'absolute',
							top : '-500px',
							left : '-500px'
						}).appendTo('body');
						
						frame.load(function(){
						
							clearTimeout(obj.timer);
							setTimeout(function(){
								try {
									// Mise  jour des informations  l'cran en fin de traitement
									obj.curr = obj.tots;
									$('span[class~=imgs]', obj.dest).removeClass('fileloader');
									$('span[class~=info]', obj.dest).text('100 %');
									bcursum = 1;
									btotsum = 1;
									for(var i in ful_normarrays)
									{
										bcursum += parseInt(ful_normarrays[i].curr);
										btotsum += parseInt(ful_normarrays[i].tots);
									}
									$(obj.params.progress).progressbar({
										value : (bcursum / btotsum * 100)
									});
									$('form[target="' + obj.idnt + '"]', $(obj.params.formcontainer)).remove();
									frame.remove();
									delete ful_normarrays[obj.idps];
									obj.params.success();
								} catch(e) {}
							}, 100);
							obj.active = false;
						});
						
						// Lancement d'un timer pour visualisation de la progression
						obj.timer = window.setTimeout("$.fn.fileprogress('" + obj.idps + "')", obj.params.delay);
						obj.nf = 0;
					});
					newf.trigger('submit');
				}
			});
		});
	
		return (this);
	};
	
	// Fonction de requtage de l'avancement du tlchargement
	$.fn.fileprogress = function(id) {
		var obj = ful_normarrays[id];
        var stamp = +new Date;
		
		$.ajax({
			url : obj.params.gauge,
			dataType : obj.params.format,
			data : {
				'fupid' : obj.idnt,
				'stamp' : stamp
			},
			success : function(data)
			{
				if (data['error'])
				{
					obj.nf++;
					if (obj.nf >= obj.params.allowedpass)
					{
						obj.active = false;
						obj.params.failed();
						return false;
					}
				}
				else
				{
					// Mise  jour des informations  l'cran
					obj.curr = data['bytes_uploaded'];
					obj.tots = data['bytes_total'];
					$('span[class~=info]', obj.dest).text((Math.floor(100 * obj.curr / obj.tots)) + ' %');
					bcursum = 1;
					btotsum = 1;
					for(var i in ful_normarrays)
					{
						bcursum += parseInt(ful_normarrays[i].curr);
						btotsum += parseInt(ful_normarrays[i].tots);
					}
					$(obj.params.progress).progressbar({
						value : (bcursum / btotsum * 100)
					});
				}
				if (obj.active)
					obj.timer = window.setTimeout("$.fn.fileprogress('" + id + "')", obj.params.delay);
			}
		});
	}	
})( jQuery );
