/*
** DELIB'APP v1.0
** Florian Guitton
**
** Composant UI maison FileUpload pour jQuery
*/

function widfilein()
{
	(function($){

		var wrapperClasses = 'fileinput-wrapper ui-widget',
			inputClasses = 'fileinput-input ui-state-default ui-widget-content ui-corner-left',
			buttonClasses = 'fileinput-button ui-state-default ui-widget-header ui-corner-right',
			buttonTextClasses = 'fileinput-button-text',
			fileClasses = 'fileinput-file',
			hoverClasses = 'ui-state-hover',
			activeClasses = 'ui-state-active',
			stateClasses = hoverClasses + ' ' + activeClasses,
			fakePath = './nowhere';

		$.widget("ui.fileinput", {
			options: {
				inputText: APP_FILEINDIQ
			},

			_create: function(){
				var self = this,
				options = self.options;

				// Cration de l'lment UI pour l'input[type=file]
				self.reorient(self.element);
				self.fileWrapper = $('<div></div>')
				.addClass(wrapperClasses)
				.hover(function(){
					self.fileButton.addClass(hoverClasses);
				},function(){
					self.fileButton.removeClass(stateClasses);
				}).bind('mousemove.fileinput', function(e){
					var x = (e.pageX - $(this).offset().left) - (self.fileFile.width() / 2);
					var y = (e.pageY - $(this).offset().top) + (self.fileFile.height() * 0.8);
					self.fileFile.css('top', y).css('left', x);
				}).insertBefore(self.fileFile.parent()),
				self.fileInput = $("<input>")
					.addClass( "ui-widget ui-widget-content ui-corner-left" )
					.val(self._getText())
					.appendTo(self.fileWrapper),
				self.fileButton = $( "<button type='button'>&nbsp;</button>" )
					.attr( "tabIndex", -1 )
					.attr( "title", "Parcourir" )
					.insertAfter(self.fileInput)
					.button({
						icons: {
							primary: "ui-icon-plus"
						},
						text: false
					})
					.removeClass( "ui-corner-all" )
					.addClass( "ui-corner-right ui-button-icon" );
			},

			_getText: function(){
				var self = this;
				fileValue = self.getValue();
				inputTextValue = self.options.inputText;
				
				//return inputTextValue;
				
				if(fileValue == ''){
					return inputTextValue;
				}else{
					return fileValue;
				}
			},

			getValue: function(){
				var self = this;
				var base = self.fileFile.val().replace(fakePath,'');
				return fileValue = base.substr(base.lastIndexOf('\\') + 1);
			},

			reset: function() {
				var self = this;
				self.fileInput.text(self.options.inputText);
			},

			// Mthode pour le changement d'input[type=file]
			reorient: function(elem) {
				var self = this;
				self.fileFile = $(elem);
				self.fileFile
					.addClass(fileClasses),
				self.fileFile.bind('change.fileinput',function(event){
					self._trigger( "selected", event, {
						fileinput: self
					});
					self.fileInput.val(self._getText());
				}).bind('focusin.fileinput',function(){
					self.fileButton.addClass(hoverClasses);
				}).bind('focusout.fileinput',function(){
					self.fileButton.removeClass(hoverClasses);
				});
			},

			// Mthode  la destruction
			destroy: function(){
				var self = this;

				self.fileInput.remove().unwrap(self.fileWrapper);
				self.fileButton.remove();
				self.fileFile.removeClass(fileClasses);
				self.fileWrapper.remove();

				$.Widget.prototype.destroy.call( self );
			},

			_setOption: function(option, value){
				var self = this;
				$.Widget.prototype._setOption.apply( self, arguments );
				switch(option){
					case "inputText":
						self.fileInput.val(self._getText());
						break;
				}
			}

		});

	})(jQuery);
}