/*
** DELIB'APP v1.0
** Florian Guitton
**
** Ensemble de fonction de chargement de contenu et de pilotage de l'agencement
*/

// Fonction de composition d'appel
function destination(module)
{
	if (arguments.length == 2)
		action = arguments[1];
	else
		action = 'index';
	d = new Date();
	return (loc_controler + '.php?time=' + d.getTime() + '&module=' + module + '&action=' + action);
}
	
// Fonction de maintient de la connexion
	function maintain()
{
	$('#status').text(APP_STT_PING);
	$.ajax({
		url: destination('tools', 'ping'),
		success: function()
		{
			$('#ping').text('1');
			tim_maintainr = setTimeout("maintain()", 60000);
		},
		error: function()
		{
			$('#ping').text('0');
			loadlogout();
		}
	});
}

// Appel au formulaire de connexion et connexion qui la rponse est pralablement positive
function login()
{
	$.ajax({
		url: destination('user'),
		success: 	function(data)
		{
			if (data == 'Redirect')
			{
				draw();
				return ;
			}
			$('#bufferbox').html(data);
			formlog();
		}
	});
}

// Dconnexion
function loadlogout()
{
	$.ajax({
		url: destination('user', 'logout'),
		success: function(){
		
			// Bon pour nouvelle action
			blk_clickates = false;
			location.reload(true);
		}
	});	
}

// Paramtrage de l'agenement de base
function draw()
{
	$('body').layout({
		closable			: false,
		slidable			: false,
		resizable			: false,
		north__size			: "90",
		south__size			: "20"
	});
	$("#supercontent").layout({
		closable			: false,
		slidable			: false,
		resizable			: true,
		west__size			: "300"
	});
	initialload();
}

// Fonction de chargement initial
function initialload()
{
	// Lancement du timer de maintient en cas de connexion non plublique
	if (loc_controler != 'public')
		tim_maintainr = setTimeout("maintain()", 60000);
		
	// Chargement du menu gnral (ruban)
	$('#superhead').load(destination('tools', 'ribbon'), function(){
		initribbon()
	});
	
	// Appel au panneau central
	loc_denomiate = 'tools';
	loadindex();
}

function initribbon()
{
	// Fonction d'initialisation du ruban et animation des boutons
	var thumbheight = $('.rbitem:first').find('.thumbnail').height();
	var thumblapsed = 20;
	var prevwheight = $('.rbitem:first').find('.preview').height();
	
	var nprevwheight = prevwheight + (thumbheight - thumblapsed);
	var nthumbheight = thumblapsed;
	
	$('.rbitem').hover(function () {
		var post = $(this);
		
		post.addClass("hover");
		post.children('.preview').animate({ height: nprevwheight }, 200);
		post.children('.thumbnail').animate({ height: nthumbheight }, 200);
	}
	, function () {
		$(this).removeClass("hover");
		$(this).children('.preview').animate({ height: prevwheight }, 200);
		$(this).children('.thumbnail').animate({ height: thumbheight }, 200);
	});
}

// Chargement de la page d'entre
function loadindex()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('tools'));
}

/*
** SECTION 'DELIBERATION'
*/

// Charger la racine
function loaddelib()
{
	loaddeliblist();
	loaddelibindex();
}

// Chargement de la liste des dlibrations non-finalises et boutons d'ajout
function loaddeliblist()
{
	$('#panelleft').loadizer();
	$('#panelleft').load(destination('delib', 'list'), function(){
		lay_deliblist.obj = $('#panelleft').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "125"
		});
		initdeliblist();
	});
}

// Chargement de la page d'introduction
function loaddelibindex()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('delib'));
}

// Chargement de l'tat d'une dlibration
function loaddelibsum()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('delib', 'sum'), {
			'ref' : nxt_reference
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: $('body').attr('gadget') ? "60" : "80"
		});
		initdelibsum();
	});
}

// Chargement du formulaire d'ajout
function loaddelibadd()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('delib', 'add'), function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80",
			onresize_end		: function(){
									$("#cpacc").accordion( "resize" );
								}
		});
		initdelibadd();
	});
}

// Chargement du formulaire de modification
function loaddelibedit()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('delib', 'edit'), {
			'ref' : nxt_reference
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80",
			onresize_end		: function(){
									$("#cpacc").accordion( "resize" );
								}
		});
		initdelibedit();
	});
}

// Initialisation de la liste des dlibrations non-finalises
function initdeliblist()
{
	// Bouton pour l'ajout d'une dlibration
	$("#cpbutadd").button().click(function() {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loaddelibadd);
	});
	
	// Bouton pour la slection d'une dlibration non-finalise dans la liste
	$(".dbitem").click( function (e) {
		dbitems($(this).attr('idi'));
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation de l'tat de la dlibration
function initdelibsum()
{
	// Agencement en mode gadget
	if ($('body').attr('gadget'))
	{
		$('#cptitle').css('font-size', '14pt');
		$('#lasteditinfo').hide();
	}
	$("button").button();
	
	// Connexion aux fichiers
	$('a', $('#sumfile')).each(function(i){
		$(this).click( function (e) {
			$(this).attr('href', 'download/' + $(this).attr('alt'));
		});
	});
	
	// Bouton pour la modification
	$('#cpbutedit').click( function (e) {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loaddelibedit);
	});
	
	// Bouton pour la suppresion
	$('#cpbutdele').click( function (e) {
		$.ajax({
			type : "POST",
			url : destination('delib', 'delete'),
			data : {'ref' : nxt_reference},
			success : 	function(data)
			{
				if (blk_clickates)
					return ;
				blk_clickates = true;
				unlayout(lay_delibedit, loaddelibindex);
				unlayout(lay_deliblist, loaddeliblist);
			}
		});
	});
	
	// Affichage du bouton de retour aux rsulats pour la section 'Recherche'
	if (loc_denomiate == 'search')
		$('#cpbutrsch').show().click(function (){
			if (blk_clickates)
				return ;
			blk_clickates = true;
			unlayout(lay_delibedit, loadshres);
		});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation du formulaire d'ajout
function initdelibadd()
{
	// Rompre la correspondance avec une dlibration prcdemment traite
	nxt_reference = null;
	
	// Mise en place du slecteur de fichier
	$("#filei").fileupload({
		action : destination('delib', 'upload'),
		gauge : destination('delib', 'gauge'),
		delay: 500,
		lister : '#cpffilelist',
		progress : '#cpfprogress',
		prodlist : '#toprodflist',
		formcontainer : '#buffer',
		deletion : function(div)
		{
			formdelfile(div);
		}
	});
	
	// Dfinition du comportement  la soumission
	formedit();
	
	// Bouton pour l'annulation	
	$('#cpbutcancel').button().click( function (e) {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loaddelibindex);
	});
	
	// Convertion des champs de date en Composant UI
	$(".tobedate").each(function (i){
		$(this).datepicker({
		altField: "#cpf" + $(this).attr('alt'),
		altFormat: "yy-mm-dd",
		showButtonPanel: true,
		showCloseButton: false,
		showClearButton: true,
		dateFormat: "DD, d MM yy"});
	});

	// Converstion des lites de slection en Composant UI
	$('select').combobox();

	// Converstion des lites de slection en Composant UI
	$('button').button();
	
	// Programmation du comportement de la liste de slection
	$('#cpfnn1').combobox({
		selected : function(){
			$('#lev2').loadizer();
			$('#lev3').html('');
			$('#lev2').load(destination('delib', 'nome'), {
					'level' : 2,
					'select' : $('#cpfnn1').val()
			}, function(){
				$('#cpfnn2').combobox({
					selected : function(){
						$('#lev3').loadizer();
						$('#lev3').load(destination('delib', 'nome'), {
							'level' : 3,
							'select' : $('#cpfnn2').val()
						}, function(){
							$("#cpfnn3").combobox({
								selected : function(){
									if ($('#cpfnn3').val() == 0)
										$('.dbnreq').show();
									else
										$('.dbnreq').hide();
								}
							});
						});						
						$('.dbnreq').show();
					}
				});
			});
			$('.dbnreq').show();
		}
	});
	
	// Initialisation de l'accordon
	$("#cpacc").accordion({
		fillSpace: true
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation du formulaire de modification
function initdelibedit()
{
	// Mise en place du slecteur de fichier
	$("#filei").fileupload({
		action : destination('delib', 'upload'),
		gauge : destination('delib', 'gauge'),
		delay: 500,
		lister : '#cpffilelist',
		progress : '#cpfprogress',
		prodlist : '#toprodflist',
		formcontainer : '#buffer',
		deletion : function(div)
		{
			formdelfile(div);
		},
		init : function(params){
			var len = $('div[id^="divfup"]', $('#cpffilelist')).each(function(idx){
				var div = $(this);
				div.addClass((idx % 2) ? 'filelistodd' : 'filelisteven');
				$('button[id^=del]', div).button().click(function(){
					params.deletion(div);
				});
			}).length;

			if (!((len % 2 && ful_identifier % 2) || (!(len % 2) && !(ful_identifier % 2))))
				ful_identifier++;
		}
	});
	
	// Dfinition du comportement  la soumission
	formedit();
	
	// Bouton pour l'annulation
	$('#cpbutcancel').click( function (e) {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loaddelibsum);
	});
	
	// Convertion des champs de date en Composant UI
	// Avec concervation des valeurs
	$(".tobedate").each(function (i){
		var v = "#cpf" + $(this).attr('alt');
		var t = $(v).val().match(/(\d+)/g);
		var d = new Date(t[0], t[1] - 1, t[2]); 
		$(this).datepicker({
		altField : v,
		altFormat : "yy-mm-dd",
		showButtonPanel: true,
		showCloseButton: false,
		showClearButton: true,
		dateFormat : "DD, d MM yy"
		});
		if ($(v).val() == '0000-00-00')
			return ;
		$(this).datepicker('setDate', d);
	});
	
	// Converstion des lites de slection en Composant UI
	$('select').combobox();

	// Converstion des lites de slection en Composant UI
	$('button').button();
	
	// Programmation du comportement de la liste de slection
	$('#cpfnn1').combobox({
		selected : function(){
			$('#lev2').loadizer();
			$('#lev3').html('');
			$('#lev2').load(destination('delib', 'nome'), {
					'level' : 2,
					'select' : $('#cpfnn1').val()
			}, function(){
				$('#cpfnn2').combobox({
					selected : function(){
						$('#lev3').loadizer();
						$('#lev3').load(destination('delib', 'nome'), {
							'level' : 3,
							'select' : $('#cpfnn2').val()
						}, function(){
							$("#cpfnn3").combobox({
								selected : function(){
									if ($('#cpfnn3').val() == 0)
										$('.dbnreq').show();
									else
										$('.dbnreq').hide();
								}
							});
						});
						$('.dbnreq').show();
					}
				});
			});
			$('.dbnreq').show();
		}
	});
	
	// Si la nomenclature est dj renseigner, lancer l'exploration rcursive
	if ($('#cpfnn1').attr('base') != 0)
	{
		$('#lev2').loadizer();$('#lev2').load(destination('delib', 'nome'), {
			'level' : 2,
			'select' : $('#cpfnn1').val(),
			'base' : nxt_reference
		}, function(){
			$('#cpfnn2').combobox({
				selected : function(){
					$('#lev3').loadizer();
					$('#lev3').load(destination('delib', 'nome'), {
						'level' : 3,
						'select' : $('#cpfnn2').val()
					}, function(){
						$("#cpfnn3").combobox({
							selected : function(){
								if ($('#cpfnn3').val() == 0)
									$('.dbnreq').show();
								else
									$('.dbnreq').hide();
							}
						});
					});
					$('.dbnreq').show();
				}
			});
			if ($('#cpfnn2').attr('base') != 0)
			{
				$('#lev3').loadizer();
				$('#lev3').load(destination('delib', 'nome'), {
					'level' : 3,
					'select' : $('#cpfnn2').val(),
					'base' : nxt_reference
				}, function(){
					$("#cpfnn3").combobox({
						selected : function(){
							if ($('#cpfnn3').val() == 0)
								$('.dbnreq').show();
							else
								$('.dbnreq').hide();
						}
					});
					if ($('#cpfnn3').attr('base') != 0)
						$('.dbnreq').hide();
				});
			}
		});
	}
	
	// Initialisation de l'accordon
	$("#cpacc").accordion({
		fillSpace: true
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

/*
** SECTION 'ASSEMBLE'
*/

// Formulaire de prise d'information pour l'ordre du jour
function getprininfo()
{
	$.ajax({
		type: 'POST',
		url: destination('aby', 'face'),
		data: {'type' : 'prin'},
		success: 	function(data)
		{
			$('#bufferbox').html(data);
			formprininfo();
		}
	});
}

// Formulaire de prise d'information la liste des dlibrations
function getlistinfo()
{
	$.ajax({
		type: 'POST',
		url: destination('aby', 'face'),
		data: {'type' : 'list'},
		success: 	function(data)
		{
			$('#bufferbox').html(data);
			formlistinfo();
		}
	});
}

// Formulaire de prise d'information pour le sommaire
function gettableinfo()
{
	$.ajax({
		type: 'POST',
		url: destination('aby', 'face'),
		data: {'type' : 'table'},
		success: 	function(data)
		{
			$('#bufferbox').html(data);
			formtableinfo();
		}
	});
}

// Charger la racine
function loadaby()
{
	loadabylist();
	loadabyindex();
}

// Chargement du panneau de slection des assembles
function loadabylist()
{
	$('#panelleft').loadizer();
	$('#panelleft').load(destination('aby', 'list'), function(){
		lay_deliblist.obj = $('#panelleft').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "100"
		});
		initabylist();
	});
}

// Chargement de la page d'introduction
function loadabyindex()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('aby'));
}

// Chargement de l'tat de l'assemble
function loadabysum()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('aby', 'sum'), {
		'type' : $('#abyinf0').val(),
		'date' : $('#abyinf1').val()
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80"
		});
		initabysum();
	});
}

// Chargement de la page de modification
function loadabyedit()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('aby', 'edit'), {
		'type' : $('#abyinf0').val(),
		'date' : $('#abyinf1').val()
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80"
		});
		initabyedit();
	});
}

// Initialisation de panneau de slection des assembles
function initabylist()
{
	// Bouton pour le sommaire
	$('#cpbutget').button().click(function(){
		gettableinfo();
	});
	
	// Liste de slection du type d'assemble
	$('#abyinf0').combobox({
		selected : function(){
			$('#inf2').loadizer();
			$('#inf2').load(destination('aby', 'select'), {
					'type' : $('#abyinf0').val()
			}, function(){
			
				// Liste de slection de la date pour le type choisi
				$('#abyinf1').combobox({
					selected : function(){
						if (blk_clickates)
							return ;
						blk_clickates = true;
						unlayout(lay_delibedit, loadabysum);
					}
				});
			});
		}
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation de la page d'tat
function initabysum()
{
	// Habillage des lments bouton
	$("button").button();
	
	// Bouton pour la modification de l'odre du jour
	$('#abyedit').click( function (e) {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loadabyedit);
	});
	
	// Bouton pour l'impression de l'ordre du jour
	$('#abyprin').click( function (e) {
		getprininfo();
		e.preventDefault();
	});
	
	// Bouton pour l'impression de la liste des dlibrations
	$('#abylist').click( function (e) {
		getlistinfo();
		e.preventDefault();
	});
	
	// Bouton pour l'impression du bordereau d'envoi
	$('#abybord').click( function (e) {
		var url = destination('aby', 'print') + '&format=bord' + '&type=' + $('#abyinf0').val() + '&date=' + $('#abyinf1').val();
		window.open(url, "", 'toolbar=no, titlebar=no, status=no, menubar=no, location=no, resizable=yes, directories=no, scollbar=yes');
		e.preventDefault();
	});
	
	// Bouton pour l'impression du recueil administratif
	$('#abyrecu').click( function (e) {
		var url = destination('aby', 'print') + '&format=recu' + '&type=' + $('#abyinf0').val() + '&date=' + $('#abyinf1').val();
		window.open(url, "", 'toolbar=no, titlebar=no, status=no, menubar=no, location=no, resizable=yes, directories=no, scollbar=yes');
		e.preventDefault();
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation de la page de modification
function initabyedit()
{
	// Dfinition des actions de soumission
	formaby();
	
	// bouton pour l'annulation
	$('#cpbutcancel').button().click( function (e) {
		if (blk_clickates)
			return ;
		blk_clickates = true;
		unlayout(lay_delibedit, loaddelibsum);
	});
	
	// Activation de glisser-dplacer pour la modification
	$( "#abysort" ).sortable({
		placeholder: "ui-state-highlight"
	});
	
	// Dsactiver la slection de texte
	$( "#abysort" ).disableSelection();
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

/*
** SECTION 'RECHERCHE'
*/

// Charger la racine
function loadsh()
{
	loadshlist();
	loadshindex();
}

// Chargement du panneau des options de recherche
function loadshlist()
{
	$('#panelleft').loadizer();
	$('#panelleft').load(destination('search', 'list'), function(){
		lay_deliblist.obj = $('#panelleft').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "100",
			north__initHidden	: $('body').attr('gadget') ? true : false
		});
		initshlist();
	});
}

// Chargement de la page d'introduction
function loadshindex()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('search'));
}

// Chargement de rsultat de recherche
function loadshres()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('search', 'select'), {
		'idxn' : idx_searchpgs,
		'city' : $('#schcit').val(),
		'titl' : $('#schtit').val(),
		'date' : $('#schdat').val(),
		'type' : $('#schaby').val(),
		'serv' : $('#schser').val(),
		'verd' : $('#schver').val(),
		'sort' : $('input:radio[name=sort]:checked').val(),
		'stty' : $('input:radio[name=sorttype]:checked').val()
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: $('body').attr('gadget') ? "60" : "80"
		});
		initshres();
	});
}

// Initialisation du panneau d'options
function initshlist()
{
	// Agencement pour gadget
	if ($('body').attr('gadget'))
	{
		var bnt_option = $('<a href="#">' + APP_TXTSEEMORE + '</a>').click(function(){
			$('#moreoption').show();
			$(this).hide();
		});
		bnt_option.insertBefore($('#moreoption'));
		$('#moreoption').hide();
		$('#dbitemcont').css('border-top-width', '0');
	}
	
	// Habillage des listes de slection
	$("#schlist select").combobox({
		selected : function(){
			if (blk_clickates)
				return ;
			blk_clickates = true;
			idx_searchpgs = 1;
			unlayout(lay_delibedit, loadshres);
		}
	});
	
	// Habillage des boutons de tri
	$("div[id^=schrad]").buttonset().change(function(){
		if (blk_clickates)
			return ;
		blk_clickates = true;
		idx_searchpgs = 1;
		unlayout(lay_delibedit, loadshres);
	});
	
	// Programmation de la recherche  retardement aprs frappe au clavier
	$("#schlist input").keyup(function (){
		typewatch(function () {
			if (blk_clickates)
				return ;
			blk_clickates = true;
			idx_searchpgs = 1;
			unlayout(lay_delibedit, loadshres);
		}, 1000);		
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation de la page des rsultats
function initshres()
{
	// Agencement pour gadget
	if ($('body').attr('gadget'))
	{
		$('#cptitle').css('font-size', '14pt');
		$('.dbitemt').css('font-size', '11px');
	}
	
	// Traitement des champs masqus
	$('#schhandle div[class^="shinf"] span').each(function(index) {
		var titmatcher = new RegExp( $.ui.autocomplete.escapeRegex($('#schtit').val()), "i" );
		var datmatcher = new RegExp( $.ui.autocomplete.escapeRegex($('#schdat').val()), "i" );
		
		// En fonction du champ surligner les lments dfinis dans les options de recherche
		switch($(this).attr('name'))
		{
			case 'title':
			{
				$(this).html($(this).text().replace(new RegExp(
								"(?![^&;]+;)(?!<[^<>]*)(" +
								$.ui.autocomplete.escapeRegex($('#schtit').val()) +
								")(?![^<>]*>)(?![^&;]+;)", "gi"
							), "<strong>$1</strong>" ));
				$(this).parent().show();
			}
				break;
			case 'ref':
			case 'note':
			case 'motif':
			{
				if ($('#schtit').val() != '' && titmatcher.test($(this).text()))
				{
					$(this).html($(this).text().replace(new RegExp(
									"(?![^&;]+;)(?!<[^<>]*)(" +
									$.ui.autocomplete.escapeRegex($('#schtit').val()) +
									")(?![^<>]*>)(?![^&;]+;)", "gi"
								), "<strong>$1</strong>" ));
					$(this).parent().show();
				}
			}
				break;
			case 'serve':
			case 'servd':
			{
				var str = "";
				var flag = false;
				var servdarray = $(this).text().split(',');
				for(var d in servdarray)
				{
					if ($('#schser').val() != 0 && servdarray[d] == $('#schser').val())
					{
						str += "<strong>" + $("#schser option[value='" + servdarray[d] + "']").text() + "</strong>";
						flag = true;
					}
					else
						str += $("#schser option[value='" + servdarray[d] + "']").text();
					
					if (d < servdarray.length - 1)
						str += ", ";
				}
				$(this).html(str);
				if (flag)
					$(this).parent().show();
			}
				break; 
			case 'daby':
			case 'dapp':
			case 'dele':
			case 'desp':
			case 'drsp':
			case 'dsee':
			case 'dcap':
			{
				if ($('#schdat').val() != '' && datmatcher.test($(this).attr('idi')))
				{
					$(this).html($(this).text());
					$(this).parent().show();
				}
			}
				break; 
			default :
				break;
		}
	});
	
	// Bouton pour la naviguation : Prcdant
	$("#schprev").button({
		icons: {
			primary: "ui-icon-triangle-1-w"
		},
		text: false
	}).click(function (){
		if (blk_clickates)
			return ;
		blk_clickates = true;
		if (idx_searchpgs > 1)
			idx_searchpgs--;
		unlayout(lay_delibedit, loadshres);
	});
	
	// Bouton pour la naviguation : Suivant
	$("#schnext").button({
		icons: {
			primary: "ui-icon-triangle-1-e"
		},
		text: false
	}).click(function (){
		if (blk_clickates)
			return ;
		blk_clickates = true;
		if (idx_searchpgs < $('#pageidxn').text())
			idx_searchpgs++;
		unlayout(lay_delibedit, loadshres);
	});
	
	// Bouton pour la consultation des dlibarations
	$("#cpbuttons button").button().click(function (){
		dbitems($(this).attr('idi'));
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

/*
** SECTION 'PARAMTRE'
*/

// Formulaire de prise d'information pour les paramtres
function getprminfo()
{
	$.ajax({
		type: "POST",
		url: destination('param', 'face'),
		data: {'ref' : nxt_reference},
		success: function(data)
		{
			$('#bufferbox').html(data);
			formprminfo();
		}
	});
}

// Charger la racine
function loadparam()
{
	loadprmlist();
	loadprmidx();
}

// Chargement du panneau d'option
function loadprmlist()
{
	$('#panelleft').loadizer();
	$('#panelleft').load(destination('param', 'list'), function(){
		lay_deliblist.obj = $('#panelleft').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80"
		});
		initprmlist();
	});
}

// Chargement de la page d'introduction
function loadprmidx()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('param'));
}

// Chargement de la page de modification
function loadprmedit()
{
	$('#panelcentral').loadizer();
	$('#panelcentral').load(destination('param', 'edit'), {
			'ref' : nxt_reference
		}, function(){
		lay_delibedit.obj = $('#panelcentral').layout({
			closable			: false,
			slidable			: false,
			resizable			: false,
			north__size			: "80"
		});
		initprmedit();
	});
}

// Initialisation des options 
function initprmlist()
{
	// Dfinition des actions de clique
	$(".pmitem").click(function() {
		pmitems($(this).attr('idi'));
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}

// Initialisation de la page de modification
function initprmedit()
{
	// Bouton pour l'ajout d'lments
	$('#prmbutadd').button().click(function(){
		getprminfo();
	});
	
	// Bouton pour la modification d'lments
	$('.prmbutmod').button().click(function(){
		setprminfo();
	});
	
	// Bouton pour la suppression d'lments
	$('.prmbutsup').button().click(function(){
		$.ajax({
			type : "POST",
			url : destination('param', 'delete'),
			data : {
				'ref' : nxt_reference,
				'id' : $(this).attr('idi'),
				'stt' : $(this).attr('stt')
				},
			success : function(data)
			{
				if (blk_clickates)
					return ;
				blk_clickates = true;
				unlayout(lay_delibedit, loadprmedit);
			}
		});
	});
	
	// Bon pour nouvelle action
	blk_clickates = false;
}
