/*
** DELIB'APP v1.0
** Florian Guitton
**
** Ensemble de fonction pour la action au clique
*/

// Gestion du formulaire de connexion
function formlog()
{
	// Extraction du dernier utilisateur connect
	if ($.cookie('dappuser').length != undefined)
		$('#frmuser').val($.cookie('dappuser'));
	
	$('form#frmlog').submit(function(){
		$("#authfail").hide();
		
		// Vrification d'erreur de saisie
		if ($('#frmuser').val() == "" || $('#frmpass').val() == "")
		{
			$('#status').text(APP_STT_INPUT);
			$('#validfail').show();
			return false;
		}
		$("#validfail").hide();
		$('#loadzone').show();
		$('#frmlog').hide();
		$.post(destination('user', 'login'), {
			uname:$('#frmuser').val(),
			pword:$('#frmpass').val()
		}, function(data)
		{
			if (data == '1')
			{
				// Rtention du non d'utilisateur
				$.cookie('dappuser', $('#frmuser').val());
				$('#boxlogin').dialog("close");
				draw();
			}
			else
			{
				$('#loadzone').hide();
				$('#frmlog').show();
				$('#authfail').show();
			}
		});
		return false;
	});
	
	// Ouverture de la bote de digalogue
	$('#boxlogin').dialog({
		modal: true,
		resizable: false,
		closeOnEscape: false,
		closeText: 'hide',
		buttons: {
			OK: function(){ $('form#frmlog').submit() }
		},
		open: function(event, ui){
			$(this).parent().children().children('.ui-dialog-titlebar-close').hide();
			$('#loadzone').hide();
			$('#loadzone').loadizer();
		}
	});
}

/*
** SECTION 'DELIBERATION'
*/

	var paramts = {};
// Gestion du formulaire de dlibration
function formedit()
{
	$("#cpbutvalid").click(function()
	{
		paramts = {id : nxt_reference};
		$("#cpacchandle :input").each(function(i)
		{
			// Vrification d'erreur de saisie
			if ($(this).attr("id") == '')
				return ;
			if ($(this).attr("id").substr(0, 3) != 'cpf')
				return ;
			paramts[$(this).attr("id").substr(3)] = $(this).val();
		});
		$.ajax({
			type : "POST",
			url : destination('delib', 'push'),
			data : paramts,
			success : 	function(data)
			{
				if (data == '1')
				{
					// En cas de succes rediriger
					if (nxt_reference == null)
						unlayout(lay_delibedit, loaddelibindex);
					else
						unlayout(lay_delibedit, loaddelibsum);
					if (loc_denomiate == 'certif')
						unlayout(lay_deliblist, loaddeliblist);
				}
				else
					boxerror(data);
			}
		});
	});
	
	// Bouton pour l'annulation
	$("cpbutcancel").click(function() {
		return false;
	});
}

// Formulation pour la suppression des fichiers
function formdelfile(div)
{
	$.ajax({
		type : "POST",
		url : destination('delib', 'unlink'),
		data : {'hash' : $(div).attr('id').substr(7)},
		success : 	function(data)
		{
			if (data == '1')
			{
				// En cas de succes rediriger
				$('input', $(div)).attr('disabled','disabled').attr({
					id : 'cpffupcanceled'
				});
				$('button', $(div)).attr('disabled','disabled');
				$(div).addClass($(div).attr('class') == 'filelistodd' ? 'filelistodddel' : 'filelistevendel');
				$('#status').text(APP_STT_SUPP);
			}
			else
				boxerror(data);
		}
	});
}

/*
** SECTION 'ASSEMBLE'
*/

// Gestion du formulaire de modification de l'ordre du jour
function formaby()
{
	var paramab = {};
	$("#abyvalid").click(function(){
		$("#abysumhandle ul").each(function(i)
		{
			paramab[$(this).attr("id")] = i;
		});
		$.ajax({
			type : "POST",
			url : destination('aby', 'push'),
			data : paramab,
			success : 	function(data)
			{
				if (data == '1' && !blk_clickates)
				{
					// En cas de succes rediriger
					blk_clickates = true;
					unlayout(lay_delibedit, loadabysum);
				}
				else
					boxerror(data);
			}
		});
	});
	
	// Bouton pour l'annulation
	$("cpbutcancel").click(function() {
		return false;
	});
}

// Gestion du formulaire de prise d'information pour l'ordre du jour
function formprininfo()
{
	// Prvention des actions par dfaut
	$('form#frmlog').submit(function(e){
		e.preventDefault();
		return false;
	});
	
	// Convertion des champs de date en Composant UI
	$(".tobedate").each(function (i){
		$(this).datepicker({
		altField: "#frm" + $(this).attr('alt'),
		altFormat: "yy-mm-dd",
		dateFormat: "DD, d MM yy"});
	});
	
	// Ouverture de la bote de digalogue
	$('#boxordinfo').dialog({
		modal: true,
		resizable: false,
		closeOnEscape: false,
		closeText: 'hide',
		buttons: {
			OK: function(){
				$("#authfail").hide();
				$("#validfail").hide();
				
				// Vrification d'erreur de saisie
				if ($('#frmdate').val() == "")
				{
					$('#status').text(APP_STT_INPUT);
					$('#validfail').show();
					return false;
				}
				$('#loadzone').show();
				$('#frmlog').hide();
				$.post(destination('aby', 'info'), {
					desig:$('#frmdesign').val(),
					datea:$('#frmdate').val(),
					quest:$('#frmquest').val()
				}, function(data)
				{
					if (data == '1')
					{
						// En cas de succes lancement de l'impression
						var url = destination('aby', 'print') + '&format=prin' + '&type=' + $('#abyinf0').val() + '&date=' + $('#abyinf1').val();
						window.open(url, "", 'toolbar=no, titlebar=no, status=no, menubar=no, location=no, resizable=yes, directories=no');
						$('#boxordinfo').dialog("close");
					}
					else
					{
						$('#loadzone').hide();
						$('#frmlog').show();
						$('#authfail').show();
					}
				});
			}
		},
		open: function(event, ui){
			$('#loadzone').hide();
			$('#loadzone').loadizer();
		},
		close: function(event, ui){
			$(this).dialog('destroy').remove();
		}
	});
}

// Gestion du formulaire de prise d'information pour le sommaire
function formtableinfo()
{
	// Prvention des actions par dfaut
	$('form#frmlog').submit(function(e){
		e.preventDefault();
		return false;
	});
	
	// Convertion des champs de date en Composant UI
	$(".tobedate").each(function (i){
		$(this).datepicker({
		altField: "#frm" + $(this).attr('alt'),
		altFormat: "yy-mm-dd",
		dateFormat: "DD, d MM yy"});
	});
	
	// Ouverture de la bote de digalogue
	$('#boxordinfo').dialog({
		modal: true,
		resizable: false,
		closeOnEscape: false,
		closeText: 'hide',
		buttons: {
			OK: function(){
				$("#validfail").hide();
				
				// Vrification d'erreur de saisie
				if ($('#frmsdate').val() == "" || $('#frmedate').val() == "")
				{
					$('#status').text(APP_STT_INPUT);
					$('#validfail').show();
					return false;
				}
				$('#loadzone').show();
				$('#frmlog').hide();
				
				// Lancement de l'impression
				var url = destination('aby', 'print') + '&format=table' + '&sdate=' + $('#frmsdate').val() + '&edate=' + $('#frmedate').val();
				window.open(url, "", 'toolbar=no, titlebar=no, status=no, menubar=no, location=no, resizable=yes, directories=no, scollbar=yes');
				$('#boxordinfo').dialog("close");
			}
		},
		open: function(event, ui){
			$('#loadzone').hide();
			$('#loadzone').loadizer();
		},
		close: function(event, ui){
			$(this).dialog('destroy').remove();
		}
	});
}

// Gestion du formulaire de prise d'information pour la liste des dlibrations
function formlistinfo()
{
	// Prvention des actions par dfaut
	$('form#frmlog').submit(function(e){
		e.preventDefault();
		return false;
	});
	
	// Convertion des case  cocher en Composant UI
	$('#frminsert').val($("#cekinsert").button().change(function(){
		$('#frminsert').val($(this).is(":checked") ? '1' : '0');
	}).is(":checked") ? '1' : '0');
	
	// Ouverture de la bote de digalogue
	$('#boxordinfo').dialog({
		modal: true,
		resizable: false,
		closeOnEscape: false,
		closeText: 'hide',
		buttons: {
			OK: function(){
				$('#loadzone').show();
				$('#frmlog').hide();
				
				// Lancement de l'impression
				var url = destination('aby', 'print') + '&format=list' + '&type=' + $('#abyinf0').val() + '&date=' + $('#abyinf1').val() + '&toinsert=' + $('#frminsert').val();
				window.open(url, "", 'toolbar=no, titlebar=no, status=no, menubar=no, location=no, resizable=yes, directories=no, scollbar=yes');
				$('#boxordinfo').dialog("close");
			}
		},
		open: function(event, ui){
			$('#loadzone').hide();
			$('#loadzone').loadizer();
		},
		close: function(event, ui){
			$(this).dialog('destroy').remove();
		}
	});
}

/*
** SECTION 'PARAMTRE'
*/

// Gestion du formulaire de prise d'information pour la liste des dlibrations
function formprminfo()
{
	// Prvention des actions par dfaut
	$('form#frmlog').submit(function(e){
		e.preventDefault();
		return false;
	});
	
	// Convertion liste de slection en Composant UI
	$("select", $('#boxprminfo')).combobox();
	
	// Convertion des case  cocher en Composant UI
	$('#frmadmin').val($("#cekadmin").button().change(function(){
		$('#frmadmin').val($(this).is(":checked") ? 'c1' : 'c0');
	}).is(":checked") ? 'c1' : 'c0');
	
	// Convertion liste de slection en Composant UI
	$('#cpfnn1').combobox({
		selected : function(){
			$('#lev2').loadizer();
			$('#lev3').html('');
			$('#lev2').load(destination('delib', 'nome'), {
					'level' : 2,
					'select' : $('#cpfnn1').val()
			}, function(){
				$('#cpfnn2').combobox();
			});
		}
	});
	
	// Ouverture de la bote de digalogue
	$('#boxprminfo').dialog({
		modal: true,
		resizable: false,
		closeOnEscape: false,
		closeText: 'hide',
		buttons: {
			OK: function(){
				$("#authfail").hide();
				$("#validfail").hide();
				vflag = false;
				paramts = {'ref' : nxt_reference};
				$("#frmlog :input").each(function(i){
					
					// Vrification d'erreur de saisie
					if ($(this).attr("id") == '')
						return ;
					if ($(this).attr("id").substr(0, 3) != 'frm' && $(this).attr("id").substr(0, 3) != 'cpf')
						return ;
					if ($(this).attr("id").substr(0, 3) == 'frm' && ($(this).val() == '' || $(this).val() == 0))
					{
						$('#status').text(APP_STT_INPUT);
						$('#validfail').show();
						vflag = true;
						return ;
					}
					paramts[$(this).attr("id").substr(3)] = $(this).val();
				});
				
				if (vflag)
					return false;
				
				$('#loadzone').show();
				$('#frmlog').hide();
				
				// En cas de succes lancement de l'impression
				$.post(destination('param', 'info'), paramts, function(data)
				{
					if (data == '1')
					{
						unlayout(lay_delibedit, loadprmedit);
						$('#boxprminfo').dialog("close");
					}
					else
					{
						$('#complmsg').html(data);
						$('#loadzone').hide();
						$('#frmlog').show();
						$('#authfail').show();
					}
				});
			}
		},
		open: function(event, ui){
			$('#loadzone').hide();
			$('#loadzone').loadizer();
		},
		close: function(event, ui){
			$(this).dialog('destroy').remove();
		}
	});
}
