<?php

	/*
	** DELIB'APP v1.0
	** Florian Guitton
	**
	** Module : Délibération
	** Action : Enregistrement
	**
	** 		Contrôleur pour l'affichage de l'état d'une délibération.
	*/
	
	$pathinfo = pathinfo(__FILE__);
	$incmodel = fphp($pathinfo['dirname'], PTH_MODEL, $pathinfo['filename']);
	
	if (facs($incmodel))
		include $incmodel;
	
	if (empty($_POST['ref']) || $_POST['ref'] == 'undefined')
		include fphp(PTH_STATS, DEF_PAGE_NF);
	$ref = $_POST['ref'];
	
	$page = new FTemplate(ftpl($pathinfo['dirname'], PTH_VIEW, $pathinfo['filename']));
	
	$page->addVar(array('CPL_TIILS' => CPL_TIILS,
		'CPL_SECFILE' => CPL_SECFILE,
		'CPL_LASTEDIT' => CPL_LASTEDIT,
		'CPL_DEBLIBEDIT' => CPL_DEBLIBEDIT,
		'CPL_DEBLIBDELE' => CPL_DEBLIBDELE,
		'CPL_DEBLIBRSCH' => CPL_DEBLIBRSCH,
		'CPL_TXTTITLE' => CPL_TXTTITLE,
		'CPL_TXTLEVEL' => CPL_TXTLEVEL,
		'CPL_TXTNOTE' => CPL_TXTNOTE,
		'CPL_TXTASST' => CPL_TXTASST,
		'CPL_TXTASSD' => CPL_TXTASSD,
		'CPL_TXTEENTIT' => CPL_TXTEENTIT,
		'CPL_TXTSERVE' => CPL_TXTSERVE,
		'CPL_TXTSERVD' => CPL_TXTSERVD,
		'CPL_TXTDATECE' => CPL_TXTDATECE,
		'CPL_TXTDATECS' => CPL_TXTDATECS,
		'CPL_TXTDATERS' => CPL_TXTDATERS,
		'CPL_TXTDATESE' => CPL_TXTDATESE,
		'CPL_TXTDATECP' => CPL_TXTDATECP,
		'CPL_TXTDATEAP' => CPL_TXTDATEAP,
		'CPL_TXTVERD' => CPL_TXTVERD,
		'CPL_TXTMOTI' => CPL_TXTMOTI,
		'CPL_TXTREF' => CPL_TXTREF));
	
	// Requête pour la sélection des données, avec relations et jointures, pour rendu textuel
	$sql = $session->db();
	$sql->query('SELECT
					V.name AS \'city\',
					C.city AS \'citynum\',
					C.last,
					C.ref,
					C.title,
					C.note,
					A.name AS \'abytype\',
					C.abydate,
					SE.name AS \'serve\',
					SDA.name AS \'servd1\',
					SDB.name AS \'servd2\',
					SDC.name AS \'servd3\',
					SDD.name AS \'servd4\',
					SDE.name AS \'servd5\',
					SDF.name AS \'servd6\',
					NA.name AS \'nn1\',
					NB.name AS \'nn2\',
					NC.name AS \'nn3\',
					C.dateappr,
					C.dateelect,
					C.dateespf,
					C.daterspf,
					C.dateeserve,
					C.dateacap,
					E.name AS \'status\',
					C.statusnote
				 FROM certifs C
				 INNER JOIN cities V ON
					V.id = C.city
				 INNER JOIN assemblies A ON
					A.id = C.abytype
				 INNER JOIN services SE ON
					SE.id = C.serve
				 INNER JOIN services SDA ON
					SDA.id = C.servd1
				 INNER JOIN services SDB ON
					SDB.id = C.servd2
				 INNER JOIN services SDC ON
					SDC.id = C.servd3
				 INNER JOIN services SDD ON
					SDD.id = C.servd4
				 INNER JOIN services SDE ON
					SDE.id = C.servd5
				 INNER JOIN services SDF ON
					SDF.id = C.servd6
				 INNER JOIN lexicon NA ON
					NA.id = C.nn1
				 INNER JOIN lexicon NB ON
					NB.id = C.nn2
				 INNER JOIN lexicon NC ON
					NC.id = C.nn3
				 INNER JOIN status E ON
					E.id = C.status
				 WHERE
					C.id = ' . $ref
				);
	
	$tab = $sql->arraizer();
	if (count($tab) != 1)
	{
		// Si la requête ne renvoi rien retourner une erreur
		include fphp(PTH_STATS, DEF_PAGE_NF);		
	}
	
	$tab = $tab[0];
		
	if (!empty($tab['ref']))
		$page->addVar(array('INT_ID' => $tab['ref']));
	else
		$page->addVar(array('INT_ID' => CPL_NONREF . ' N°' . $ref));
	
	$page->addVar(array(
		'LOC_LASTEDIT' => loc_datetime($tab['last']),
		'LOC_TXTEENTIT' => $tab['city'],
		'LOC_TXTTITLE' => $tab['title'],
		'LOC_TXTNOTE' => $tab['note'],
		'LOC_TXTASST' => $tab['abytype'],
		'LOC_TXTASSD' => loc_date($tab['abydate']),
		'LOC_TXTSERVE' => $tab['serve']));
	
	if (!empty($tab['servd1']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd1']));
	if (!empty($tab['servd2']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd2']));
	if (!empty($tab['servd3']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd3']));
	if (!empty($tab['servd4']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd4']));
	if (!empty($tab['servd5']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd5']));
	if (!empty($tab['servd6']))
		$page->addArray('sumservd', array('LOC_TXTSERVD' => $tab['servd6']));
	
	
	if (!empty($tab['nn1']))
		$page->addArray('sumnn', array('LOC_TXTLEVEL' => $tab['nn1']));
	if (!empty($tab['nn2']))
		$page->addArray('sumnn', array('LOC_TXTLEVEL' => $tab['nn2']));
	if (!empty($tab['nn3']))
		$page->addArray('sumnn', array('LOC_TXTLEVEL' => $tab['nn3']));
	
	
	$page->addVar(array('LOC_TXTDATECE' => loc_date($tab['dateelect']),
		'LOC_TXTDATECS' => loc_date($tab['dateespf']),
		'LOC_TXTDATERS' => loc_date($tab['daterspf']),
		'LOC_TXTDATESE' => loc_date($tab['dateeserve']),
		'LOC_TXTDATECP' => loc_date($tab['dateacap']),
		'LOC_TXTDATEAP' => loc_date($tab['dateappr']),
		'LOC_TXTVERD' => $tab['status'],
		'LOC_TXTMOTI' => $tab['statusnote'],
		'LOC_TXTREF' => $tab['ref']));
		
	if ($session->connected() && $session->city == $tab['citynum'])
		$page->addVar(array('CPL_COMPBUTN' => fphp(PTH_MODULE, 'delib/comp')));
	else
		$page->addVar(array('CPL_COMPBUTN' => ''));
	
	// Requête pour la sélection de fichiers correspondants à la délibération
	$sql->query('SELECT * FROM files WHERE certif = ' . $ref);
	$tab = $sql->arraizer();
	
	foreach($tab as $elem)
	{
		if (file_exists(PTH_FILE . '/' . $elem['hash']))
			$page->addArray('sumfile', array('NAME' => $elem['name'], 'HASH' => $elem['hash']));
	}
		
	$page->compute();
	$page->display();
	
	
?>