<?php

	/*
	** DELIB'APP v1.0
	** Florian Guitton
	**
	** Module : Délibération
	** Action : Ajout
	**
	** 		Contrôleur pour l'affichage d'un formulaire renseigné pour la modification
	**		d'une délibération
	*/
	
	$pathinfo = pathinfo(__FILE__);
	$incmodel = fphp($pathinfo['dirname'], PTH_MODEL, $pathinfo['filename']);
	
	if (facs($incmodel))
		include $incmodel;
	
	if (empty($_POST['ref']) || $_POST['ref'] == 'undefined')
		include fphp(PTH_STATS, DEF_PAGE_NF);
	$ref = $_POST['ref'];
	
	$page = new FTemplate(ftpl($pathinfo['dirname'], PTH_VIEW, $pathinfo['filename']));
	
	// Importation du gabarit de formulaire via récusivité avant remplissage
	$page->addVar(array(
		'CPL_TIILE' => CPL_TIILE,
		'CPL_LASTEDIT' => CPL_LASTEDIT,
		'CPL_FIELDS' => fphp(PTH_MODULE, 'delib/field'),
		'CPL_DEBLIBVAL' => CPL_DEBLIBVAL,
		'APP_BNTCAN' => APP_BNTCAN));
	
	$page->compute();
	
	// Requête de sélection des données en base pour la délibération $ref
	$sql = $session->db();
	$sql->query('SELECT * FROM certifs WHERE id = ' . $ref);
	
	$tab = $sql->arraizer();
	$tab = $tab[0];
	
	// Replissage
	if (!empty($tab['ref']))
		$page->addVar(array('INT_ID' => $tab['ref']));
	else
		$page->addVar(array('INT_ID' => CPL_NONREF . ' N°' . $ref));
	
	$page->addVar(array(
		'LOC_LASTEDIT' => loc_date($tab['last']),
		'LOC_TXTTITLE' => htmlentities($tab['title'], ENT_QUOTES | ENT_IGNORE, "UTF-8"),
		'LOC_TXTNOTE' => htmlentities($tab['note'], ENT_QUOTES | ENT_IGNORE, "UTF-8"),
		'LOC_TXTASST' => $tab['abytype'],
		'LOC_TXTASSD' => $tab['abydate'],
		'LOC_TXTSERVE' => $tab['serve'],
		'LOC_TXTSERVD1' => $tab['servd1'],
		'LOC_TXTSERVD2' => $tab['servd2'],
		'LOC_TXTSERVD3' => $tab['servd3'],
		'LOC_TXTSERVD4' => $tab['servd4'],
		'LOC_TXTSERVD5' => $tab['servd5'],
		'LOC_TXTSERVD6' => $tab['servd6'],
		'LOC_TXTLEVEL' => $tab['nn1'],
		'LOC_TXTDATECE' => $tab['dateelect'],
		'LOC_TXTDATECS' => $tab['dateespf'],
		'LOC_TXTDATERS' => $tab['daterspf'],
		'LOC_TXTDATESE' => $tab['dateeserve'],
		'LOC_TXTDATECP' => $tab['dateacap'],
		'LOC_TXTDATEAP' => $tab['dateappr'],
		'LOC_TXTVERD' => $tab['status'],
		'LOC_TXTMOTI' => htmlentities($tab['statusnote'], ENT_QUOTES | ENT_IGNORE, "UTF-8"),
		'LOC_TXTREF' => htmlentities($tab['ref'], ENT_QUOTES | ENT_IGNORE, "UTF-8"),
		'LOC_TXTORD' => $tab['ord']));
	
	// Requête de sélection des fichiers joints
	$sql->query('SELECT * FROM files WHERE certif = ' . $ref);
	
	$tab = $sql->arraizer();
	
	$page->addArray('cpffiles', array('TOPID' => 'toprodflist', 'TOPCLASS' => 'notdisp', 'INPUT' => 'fupname', 'DELETE' => 'del', 'VALUE' => ''));
	foreach ($tab as $elem)
		$page->addArray('cpffiles', array('TOPID' => 'divfup-' . $elem['hash'], 'TOPCLASS' => '', 
										  'INPUT' => 'cpffup' . $elem['hash'], 'DELETE' => 'del' . $elem['hash'], 
										  'VALUE' => $elem['name']));
	
	$page->compute();
	$page->display();
	
?>