<?php

	/*
	** DELIB'APP v1.0
	** Florian Guitton
	**
	** Fonctions et surcharges de classes pour la composition et l'exportation PDF
	** des impression
	*/
	
	// Surcharge pour entêtes vide et pieds de page datés, numérotés
	class FDocDated extends TCPDF
	{
		public function Header()
		{
		}

		public function Footer()
		{
			$this->SetY(-15);
			$this->SetFont('calibri', 'I', 8);
			$this->Cell(0, 10, 'Édité le ' . loc_datetime(date('Y-m-d H:i:s')), 0, false, 'L', 0, '', 0, false, 'T', 'M');
			$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().' sur '.$this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
		}
	}
	
	// Surcharge pour entêtes et pieds de page vides
	class FDocNonDated extends TCPDF
	{
		public function Header()
		{
		}

		public function Footer()
		{
		}
	}
	
	// Fonction de configuration de TCPDF voir documentation (http://www.tcpdf.org/docs.php)
	function pdfizer($pdf)
	{
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(format_username($session->user));
		$pdf->SetTitle('TCPDF Example 001');
		$pdf->SetSubject('TCPDF Tutorial');
		$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING);

		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		$pdf->setLanguageArray($l);

		$pdf->setFontSubsetting(true);
		$pdf->setBarcode(date('Y-m-d H:i:s'));
		$pdf->SetFont('calibri', '', 11, '', true);
		
		return ($pdf);
	}
	
	// Fonction pour l'impression de l'ordre du jour 
	function prinformat($tab)
	{
		global $session;

		$page = new FTemplate(ftpl(PTH_MODULE, 'aby', PTH_VIEW, 'prin.doc'));
		
		// Requête de sélection des paramètres envoyés depuis le formulaire de saisie d'informations complémentaires
		$sql = $session->db();
		$sql->query('SELECT name, val FROM settings WHERE user = ' . $session->id);
		
		$tmp = $sql->arraizer();
		
		foreach ($tmp as $elem)
			$res[$elem['name']] = $elem['val'];

		if ($tab['info']['type'] != 3)
			$page->addArray('desig', array('TEXT' => ABY_EDDESIGN));

		$page->addVar(array(
			'CPL_TXTREF' => CPL_TXTREF,
			'CPL_TXTTITLE' => CPL_TXTTITLE,
			
			'ABY_EDAPPROB' => ABY_EDAPPROB,
			'ABY_EDQUESTION' => ABY_EDQUESTION,
			'ABY_EDSERVNAME' => ABY_EDSERVNAME,
			'APP_WORDPOSSESS' => APP_WORDPOSSESS,
			
			'LOC_TYPE' => ABY_TIILO,
			'LOC_ASSNAME' => $tab['info']['assname'],
			'LOC_DATE' => loc_date($tab['info']['date']),
			'LOC_DATEAPP' => loc_date($res['approvaldate']),
			'LOC_QUEST' => $res['question']));
				
		$i = 0;
		foreach ($tab['data'] as $elem)
			$page->addArray('data', array('TITLE' => $elem['title'], 'ORD' => ++$i, 'COL' => (($i % 2) ? '#DDDDDD' : '#FFFFFF'), 'COLEXP' => (($i % 2) ? '#E9E9E9' : '#FAFAFA')));
		
		$page->compute();
		$page->display();
		
		/*
		** Exportation PDF désactivé.
		** Décommenter le bloc suivant tout en commentant la ligne précédente pour activer
		**
		$html = $page->getPage();
				
		$pdf = pdfizer(new FDocNonDated(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false));
		$pdf->AddPage();

		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		$pdf->Output('PRIN.pdf', 'I');
		*/
	}
	
	// Fonction pour l'impression du bordereau pour une date date donnée
	function bordformat($tab)
	{
		global $session;

		$page = new FTemplate(ftpl(PTH_MODULE, 'aby', PTH_VIEW, 'bord.doc'));
		
		$page->addVar(array(
			'CPL_TXTREF' => CPL_TXTREF,
			'CPL_TXTTITLE' => CPL_TXTTITLE,
			
			'APP_NDESIRE' => APP_NDESIRE,
			'APP_WORDPOSSESS' => APP_WORDPOSSESS,
			
			'LOC_TYPE' => ABY_BORD,
			'LOC_ASSNAME' => $tab['info']['assname'],
			'LOC_DATE' => loc_date($tab['info']['date'])));
		
		$i = 0;
		foreach ($tab['data'] as $elem)
			$page->addArray('data', array('TITLE' => $elem['title'], 'REF' => $elem['ref'], 'COL' => ((++$i % 2) ? '#DDDDDD' : '#FFFFFF'), 'COLEXP' => (($i % 2) ? '#C0C0C0' : '#EAEAEA')));
		
		$page->compute();
		$page->display();
		
		/*
		** Exportation PDF désactivé.
		** Décommenter le bloc suivant tout en commentant la ligne précédente pour activer
		**
		$html = $page->getPage();		
		
		$pdf = pdfizer(new FDocDated(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false));
		$pdf->AddPage();

		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		$pdf->Output('BORD.pdf', 'I');
		*/
	}
	
	// Fonction pour l'impression de la liste des délibérations pour une date date donnée
	function listformat($tab)
	{
		global $session;

		$page = new FTemplate(ftpl(PTH_MODULE, 'aby', PTH_VIEW, 'list.doc'));
		
		$page->addVar(array(
			'CPL_TXTREF' => CPL_TXTREF,
			'CPL_TXTTITLE' => CPL_TXTTITLE,
			'CPL_TXTVERD' => CPL_TXTVERD,
			
			'APP_WORDPOSSESS' => APP_WORDPOSSESS,
			'ABY_TXTTAKEN' => ABY_TXTTAKEN,
			'ABY_TXTTAKENCLAUSESHORT' => ABY_TXTTAKENCLAUSESHORT,
			
			'LOC_TYPE' => ABY_LIST,
			'LOC_ASSNAME' => $tab['info']['assname'],
			'LOC_DATE' => loc_date($tab['info']['date'])));
				
		if (!empty($tab['info']['inse']))
			$page->addArray('insert', array('NULL' => ''));
		else
			$page->addArray('norm', array('NULL' => ''));
		
		$i = 0;
		foreach ($tab['data'] as $elem)
			$page->addArray('data', array('TITLE' => $elem['title'], 'REF' => $elem['ref'], 'STATUS' => $elem['status'], 'COL' => ((++$i % 2) ? '#DDDDDD' : '#FFFFFF')));
		
		$page->compute();
		$page->display();
		
		/*
		** Exportation PDF désactivé.
		** Décommenter le bloc suivant tout en commentant la ligne précédente pour activer
		**
		$html = $page->getPage();		
		
		$pdf = pdfizer(new FDocDated(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false));
		$pdf->AddPage();

		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		$pdf->Output('LIST.pdf', 'I');
		*/
	}
	
	// Fonction pour l'impression du receuil administratif pour une date date donnée
	function recuformat($tab)
	{
		global $session;

		$page = new FTemplate(ftpl(PTH_MODULE, 'aby', PTH_VIEW, 'recu.doc'));
		
		$page->addVar(array(
			'CPL_TXTREF' => CPL_TXTREF,
			'CPL_TXTTITLE' => CPL_TXTTITLE,
			
			'APP_WORDPOSSESS' => APP_WORDPOSSESS,
			
			'LOC_TYPE' => ABY_RECU,
			'LOC_ASSNAME' => $tab['info']['assname'],
			'LOC_DATE' => loc_date($tab['info']['date'])));
		
		$i = 0;
		foreach ($tab['data'] as $elem)
			$page->addArray('data', array('TITLE' => $elem['title'], 'REF' => $elem['ref'], 'STATUS' => $elem['status'], 'COL' => ((++$i % 2) ? '#DDDDDD' : '#FFFFFF')));
		
		$page->compute();		
		$page->display();
		
		/*
		** Exportation PDF désactivé.
		** Décommenter le bloc suivant tout en commentant la ligne précédente pour activer
		**
		$html = $page->getPage();		
		
		$pdf = pdfizer(new FDocNonDated(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false));
		$pdf->AddPage();

		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		$pdf->Output('RECU.pdf', 'I');
		*/
	}
	
	// Fonction pour l'impression de sommaire de $tab['info']['sdate'] à $tab['info']['edate']
	function tableformat($tab)
	{
		global $session;

		$page = new FTemplate(ftpl(PTH_MODULE, 'aby', PTH_VIEW, 'table.doc'));
				
		$page->addVar(array(
			'LOC_TYPE' => ABY_SOMM,
			'LOC_ASSNAME' => $tab['info']['assname'],
			'LOC_SDATE' => loc_date($tab['info']['sdate']),
			'LOC_EDATE' => loc_date($tab['info']['edate'])));
		
		foreach ($tab['data'] as $elem)
			$temp[$elem['abytype']][] = $elem['abydate'];
		
		$i = 0;
		$f = null;
		if (count($temp) > 0)
			foreach ($temp as $key => $val)
			{
				if ($key != $f)
				{
					$page->addArray('section', array('TITLE' => $key, 'ID' => ++$i));
					$f = $key;
				}
				foreach($val as $item)
					$cont['data' . $i][] = array('DATE' => loc_date($item));
			}
		else
			$page->addArray('section', array('TITLE' => '', 'ID' => 0));
		
		$page->compute();
		if (count($cont) > 0)
		{
			$page->addArrayPrep($cont);
			$page->compute();
		}
		$page->display();
		
		/*
		** Exportation PDF désactivé.
		** Décommenter le bloc suivant tout en commentant la ligne précédente pour activer
		**
		$html = $page->getPage();
		
		$pdf = pdfizer(new FDocNonDated(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false));
		$pdf->AddPage();

		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		$pdf->Output('TABLE.pdf', 'I');
		*/
	}
?>