<?php

	/*
	** Classe de gestion LDAP
	*/

	class	FTemplate
	{
		private		$page = null;
		private		$info = null;
		private		$recu = true;
		
		/*
		** Constructeur de classe
		*/
		
		public function		__construct($file)
		{
			if (facs($file))
			{
				$handle = fopen($file, 'rb');
				$this->page = fread($handle, filesize ($file));
				$this->info = array();
				fclose ($handle);
			}
			else
			{
				include fphp(PTH_STATS, DEF_PAGE_NF);
			}
		}
		
		/*
		** Mthode d'ajout de variables
		*/
		
		public function		addVar($var = array())
		{
			if (empty($var))
				exit;

			foreach ($var as $constant => $data)
				$this->info['.'][][$constant] = $data;
		}
		
		public function		addArrayPrep($prep)
		{
			if (empty($prep))
				exit ;
			
			foreach($prep as $type => $var)
				$this->info[$type] = $var;
		}
		
		public function		addArray($type, $var = array())
		{
			if (empty($var))
				exit;
			
			$id = 0;
			if (!empty($this->info[$type]))
				$id = (count($this->info[$type]) != 0) ? (count($this->info[$type])) : 0;
				
			foreach ($var as $constant => $data)
				$this->info[$type][$id][$constant] = $data;
		}
		
		/*
		** Mthode de traitement
		*/
		
		public function		recursive($val)
		{
			$this->recu = $val;
		}
		
		public function		compute()
		{
			foreach($this->info as $type => $info)
			{
				if ($type == '.')
				{
					for ($i = 0, $imax = count($info); $i < $imax; $i++)
					{
						foreach ($info[$i] as $constant => $data)
						{
							if ($this->recu and facs($data))
								$data = $this->link($data);
							$this->page = @preg_replace('`{' . $constant . '}`', $data, $this->page);
						}
					}
				}
				else
				{
					$begt = htmlentities('<!-- BEG ' . $type . ' --');
					$endt = htmlentities('!-- END ' . $type . ' -->');
					$elem = array_map('trim', explode("\n", htmlentities($this->page)));
					
					while (array_search($begt, $elem) !== false && array_search($endt, $elem) !== false)
					{
						$block = '';
						for ($i = 0; $i < count($info); $i++)
						{
							$elem = array_map('trim', explode("\n", htmlentities($this->page)));
							$stag = (array_search($begt, $elem)) + 1;
							$etag = (array_search($endt, $elem)) - 1;
							$ltag = ($etag - $stag) + 1;
							$btag = implode("\n", array_slice($elem, $stag, $ltag));
							
							foreach($info[$i] as $constant => $data)
							{
								if ($this->recu and facs($data))
									$data = $this->link($data);
								$btag = preg_replace('`{' . $type . '.' . $constant . '}`', $data, $btag);
							}
							
							$block = ($block == '') ? $btag : $block . "\n" . $btag;
						}
						
						$block = explode ("\n", $block);
						$fpart = array_slice($elem, 0, $stag - 1);
						$spart = array_slice($elem, $stag + $ltag + 1);
						
						$this->page = implode("\n", array_map('html_entity_decode', array_merge($fpart, $block, $spart)));
						$elem = array_map('trim', explode("\n", htmlentities($this->page)));
					}
				}
			}
		}
		
		public function		getPage()
		{
			return $this->page;
		}
		
		public function		display()
		{
			echo $this->page;
		}
		
		private function	link($file)
		{
			global $session;
			ob_start();
			include $file;
			$buffer = ob_get_flush();
			ob_clean();
			
			return $buffer;
		}
	}
	
?>