<?php

	/*
	** Classe de gestion de Session
	*/
		
	class FSession
	{
		var $sql = null;
		
		/*
		** Constructeur et destructeur de classe
		*/
		
		public function			__construct($time = null, $limi = null)
		{
			if ($time)
				session_cache_expire($time);
			if ($limi)
				session_cache_limiter($limi);
			$this->start();
		}
		
		public function			__destruct()
		{
			$this->commit();
		}
		
		public function			__set($name, $value)
		{
			$_SESSION[$name] = $value;
		}
		
		public function			__get($name)
		{
			if (isset($_SESSION[$name]))
				return ($_SESSION[$name]);
		}

		public function			__isset($name)
		{
			return (isset($_SESSION[$name]));
		}
		
		public function			__unset($name)
		{
			unset($_SESSION[$name]);
		}
		
		public function			start()
		{
			session_start();
		}
		
		public function			db()
		{
			return ($this->sql);
		}
		
		public function			connected()
		{
			return (isset($_SESSION['isauth']) && $_SESSION['isauth']);
		}
		
		public function			authenticate($persist, $user = '', $pass = '')
		{
			if (!$persist && isset($_SESSION['isauth']) && $_SESSION['isauth'])
			{
				if ($_SESSION['user'] != $user || $_SESSION['pass'] != sha1($pass))
				{
					$this->stop();
					$this->start();
				}
			}
			
			$catg = 'FSQL' . trim(SQL_TYPE)	. '()';
				eval("\$this->sql = new $catg;");
			
			try
			{
				$this->sql->open(SQL_SERV, SQL_PORT, SQL_USER, SQL_PASS);
				$this->sql->select(SQL_DB);
				$this->sql->query('SET NAMES "utf8"');
			}
			catch (ExceptFSQL $e)
			{
				echo $e->getMessage();
				$this->sql = null;
				die();
			}
			
			if (!isset($_SESSION['isauth']) || !$_SESSION['isauth'])
			{
				$_SESSION['isauth'] = false;
				try
				{
					$ldap = new FLDAP();
					$ldap->setUser(DIR_USER);
					$ldap->setPass(DIR_PASS);
					
					global $DIR_LOCATION;
					foreach ($DIR_LOCATION as $key => $val)
					{
						$ldap->addServ($key);
						$ldap->addBase($val);
					}
					$ldap->connect();
					if ($ldap->authenticate($user, $pass))
						$_SESSION['isauth'] = true;
					$ldap = null;
				}
				catch (ExceptFLDAP $e)
				{
				//	echo $e->getMessage();
					$ldap = null;
				}
				
				/*
				if (!$_SESSION['isauth'])
				{
					try
					{
						$this->sql->query('SELECT c_id FROM usr_table WHERE usr_table.c_login = "' . $user . '" AND usr_table.c_pass = "' . sha1($pass) . '"');
						$tab = $this->sql->arraizer();
						
						if (count($tab) == 1)
							$_SESSION['isauth'] = true;
					}
					catch (ExceptFSQL $e)
					{
						echo $e->getMessage();
						$this->sql = null;
					}
				}
				*/
			}
			
			if (!$persist && $_SESSION['isauth'])
			{
				$this->sql->query('SELECT * FROM users WHERE login = \'' . $user . '\'');
				$sids = $this->sql->arraizer();
				
				if (count($sids) != 1)
				{
					$_SESSION['isauth'] = false;
					return ;
				}
				
				foreach ($sids[0] as $key => $val)
					$_SESSION[$key] = $val;
					
				$_SESSION['user'] = $user;
				$_SESSION['pass'] = sha1($pass);
			}
		}

		public function			commit()
		{
			session_commit();
		}

		
		public function			stop()
		{
			session_unset();
			session_destroy();
			$_SESSION = array();
		}
	}
?>